package io.qt.qt3d.render;


/**
 * <p>Provides the facility to load an existing Scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html">Qt3DRender::QSceneLoader</a></p>
 */
public class QSceneLoader extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSceneLoader.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#ComponentType-enum">Qt3DRender::QSceneLoader::ComponentType</a></p>
     */
    public enum ComponentType implements io.qt.QtEnumerator {
        UnknownComponent(0),
        GeometryRendererComponent(1),
        TransformComponent(2),
        MaterialComponent(3),
        LightComponent(4),
        CameraLensComponent(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComponentType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ComponentType resolve(int value) {
            switch (value) {
            case 0: return UnknownComponent;
            case 1: return GeometryRendererComponent;
            case 2: return TransformComponent;
            case 3: return MaterialComponent;
            case 4: return LightComponent;
            case 5: return CameraLensComponent;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#Status-enum">Qt3DRender::QSceneLoader::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        None(0),
        Loading(1),
        Ready(2),
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#status-prop">Qt3DRender::QSceneLoader::statusChanged(Qt3DRender::QSceneLoader::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.render.QSceneLoader.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QSceneLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSceneLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#QSceneLoader">Qt3DRender::QSceneLoader::QSceneLoader(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QSceneLoader(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSceneLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#component">Qt3DRender::QSceneLoader::component(QString,Qt3DRender::QSceneLoader::ComponentType)const</a></p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.qt3d.core.QComponent component(java.lang.String entityName, io.qt.qt3d.render.QSceneLoader.ComponentType componentType){
        return component_native_cref_QString_Qt3DRender_QSceneLoader_ComponentType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), entityName, componentType.value());
    }
    
    private native io.qt.qt3d.core.QComponent component_native_cref_QString_Qt3DRender_QSceneLoader_ComponentType_constfct(long __this__nativeId, java.lang.String entityName, int componentType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#entity">Qt3DRender::QSceneLoader::entity(QString)const</a></p>
     */
    @SuppressWarnings({"exports"})
    public final io.qt.qt3d.core.QEntity entity(java.lang.String entityName){
        return entity_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), entityName);
    }
    
    private native io.qt.qt3d.core.QEntity entity_native_cref_QString_constfct(long __this__nativeId, java.lang.String entityName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#entityNames">Qt3DRender::QSceneLoader::entityNames()const</a></p>
     */
    public final io.qt.core.QStringList entityNames(){
        return entityNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList entityNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl arg){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long arg);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#source-prop">Qt3DRender::QSceneLoader::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qsceneloader.html#status-prop">Qt3DRender::QSceneLoader::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QSceneLoader.Status status(){
        return io.qt.qt3d.render.QSceneLoader.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSceneLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSceneLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSceneLoader instance, QDeclarativeConstructor constructor);
    
}
