package io.qt.qt3d.render;


/**
 * <p>Enables remapping depth values written into the depth buffer</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html">Qt3DRender::QDepthRange</a></p>
 */
public class QDepthRange extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDepthRange.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::farValueChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="farValue")
    public final Signal1<@io.qt.QtPrimitiveType Double> farValueChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::nearValueChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="nearValue")
    public final Signal1<@io.qt.QtPrimitiveType Double> nearValueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDepthRange(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDepthRange() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QDepthRange(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDepthRange instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::farValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="farValue")
    @io.qt.QtUninvokable
    public final double farValue(){
        return farValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double farValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::nearValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="nearValue")
    @io.qt.QtUninvokable
    public final double nearValue(){
        return nearValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double nearValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#farValue-prop">Qt3DRender::QDepthRange::setFarValue(double)</a></p>
     */
    @io.qt.QtPropertyWriter(name="farValue")
    public final void setFarValue(double value){
        setFarValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setFarValue_native_double(long __this__nativeId, double value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthrange.html#nearValue-prop">Qt3DRender::QDepthRange::setNearValue(double)</a></p>
     */
    @io.qt.QtPropertyWriter(name="nearValue")
    public final void setNearValue(double value){
        setNearValue_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setNearValue_native_double(long __this__nativeId, double value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDepthRange(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QDepthRange(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QDepthRange instance, QDeclarativeConstructor constructor);
    
}
