package io.qt.qt3d.render;


/**
 * <p>Handles the texture loading and setting the texture's properties</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html">Qt3DRender::QTextureLoader</a></p>
 */
public class QTextureLoader extends io.qt.qt3d.render.QAbstractTexture
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextureLoader.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#mirrored-prop">Qt3DRender::QTextureLoader::mirroredChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mirrored")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> mirroredChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#source-prop">Qt3DRender::QTextureLoader::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QTextureLoader(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextureLoader() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#QTextureLoader">Qt3DRender::QTextureLoader::QTextureLoader(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QTextureLoader(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextureLoader instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#mirrored-prop">Qt3DRender::QTextureLoader::isMirrored()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mirrored")
    @io.qt.QtUninvokable
    public final boolean isMirrored(){
        return isMirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isMirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#setMirrored">Qt3DRender::QTextureLoader::setMirrored(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mirrored")
    public final void setMirrored(boolean mirrored){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), mirrored);
    }
    
    private native void setMirrored_native_bool(long __this__nativeId, boolean mirrored);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#setSource">Qt3DRender::QTextureLoader::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureloader.html#source-prop">Qt3DRender::QTextureLoader::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextureLoader(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QTextureLoader(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QTextureLoader instance, QDeclarativeConstructor constructor);
    
}
