package io.qt.qt3d.render;


/**
 * <p>Tests the fragment shader's depth value against the depth of a sample being written to</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html">Qt3DRender::QDepthTest</a></p>
 */
public class QDepthTest extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDepthTest.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::QDepthTest::DepthFunction</a></p>
     */
    public enum DepthFunction implements io.qt.QtEnumerator {
        Never(512),
        Always(519),
        Less(513),
        LessOrEqual(515),
        Equal(514),
        GreaterOrEqual(518),
        Greater(516),
        NotEqual(517);

        private DepthFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DepthFunction resolve(int value) {
            switch (value) {
            case 512: return Never;
            case 519: return Always;
            case 513: return Less;
            case 515: return LessOrEqual;
            case 514: return Equal;
            case 518: return GreaterOrEqual;
            case 516: return Greater;
            case 517: return NotEqual;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::depthFunctionChanged(Qt3DRender::QDepthTest::DepthFunction)</a></p>
     */
    @io.qt.QtPropertyNotify(name="depthFunction")
    public final Signal1<io.qt.qt3d.render.QDepthTest.DepthFunction> depthFunctionChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QDepthTest(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDepthTest() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#QDepthTest">Qt3DRender::QDepthTest::QDepthTest(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QDepthTest(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDepthTest instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::depthFunction()const</a></p>
     */
    @io.qt.QtPropertyReader(name="depthFunction")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QDepthTest.DepthFunction depthFunction(){
        return io.qt.qt3d.render.QDepthTest.DepthFunction.resolve(depthFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int depthFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::setDepthFunction(Qt3DRender::QDepthTest::DepthFunction)</a></p>
     */
    @io.qt.QtPropertyWriter(name="depthFunction")
    public final void setDepthFunction(io.qt.qt3d.render.QDepthTest.DepthFunction depthFunction){
        setDepthFunction_native_Qt3DRender_QDepthTest_DepthFunction(QtJambi_LibraryUtilities.internal.nativeId(this), depthFunction.value());
    }
    
    private native void setDepthFunction_native_Qt3DRender_QDepthTest_DepthFunction(long __this__nativeId, int depthFunction);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QDepthTest(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QDepthTest(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QDepthTest instance, QDeclarativeConstructor constructor);
    
}
