package io.qt.qt3d.render;


/**
 * <p>A base class to be used to provide textures</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html">Qt3DRender::QAbstractTexture</a></p>
 */
public class QAbstractTexture extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTexture.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::ComparisonFunction</p>
     */
    public enum ComparisonFunction implements io.qt.QtEnumerator {
        CompareLessEqual(515),
        CompareGreaterEqual(518),
        CompareLess(513),
        CompareGreater(516),
        CompareEqual(514),
        CommpareNotEqual(517),
        CompareAlways(519),
        CompareNever(512);

        private ComparisonFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ComparisonFunction resolve(int value) {
            switch (value) {
            case 515: return CompareLessEqual;
            case 518: return CompareGreaterEqual;
            case 513: return CompareLess;
            case 516: return CompareGreater;
            case 514: return CompareEqual;
            case 517: return CommpareNotEqual;
            case 519: return CompareAlways;
            case 512: return CompareNever;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::ComparisonMode</p>
     */
    public enum ComparisonMode implements io.qt.QtEnumerator {
        CompareRefToTexture(34894),
        CompareNone(0);

        private ComparisonMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ComparisonMode resolve(int value) {
            switch (value) {
            case 34894: return CompareRefToTexture;
            case 0: return CompareNone;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapFace</a></p>
     */
    public enum CubeMapFace implements io.qt.QtEnumerator {
        CubeMapPositiveX(34069),
        CubeMapNegativeX(34070),
        CubeMapPositiveY(34071),
        CubeMapNegativeY(34072),
        CubeMapPositiveZ(34073),
        CubeMapNegativeZ(34074),
        AllFaces(34075);

        private CubeMapFace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CubeMapFace resolve(int value) {
            switch (value) {
            case 34069: return CubeMapPositiveX;
            case 34070: return CubeMapNegativeX;
            case 34071: return CubeMapPositiveY;
            case 34072: return CubeMapNegativeY;
            case 34073: return CubeMapPositiveZ;
            case 34074: return CubeMapNegativeZ;
            case 34075: return AllFaces;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::Filter</a></p>
     */
    public enum Filter implements io.qt.QtEnumerator {
        Nearest(9728),
        Linear(9729),
        NearestMipMapNearest(9984),
        NearestMipMapLinear(9986),
        LinearMipMapNearest(9985),
        LinearMipMapLinear(9987);

        private Filter(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Filter resolve(int value) {
            switch (value) {
            case 9728: return Nearest;
            case 9729: return Linear;
            case 9984: return NearestMipMapNearest;
            case 9986: return NearestMipMapLinear;
            case 9985: return LinearMipMapNearest;
            case 9987: return LinearMipMapLinear;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QAbstractTexture::HandleType</p>
     */
    public enum HandleType implements io.qt.QtEnumerator {
        NoHandle(0),
        OpenGLTextureId(1);

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return OpenGLTextureId;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        None(0),
        Loading(1),
        Ready(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target</a></p>
     */
    public enum Target implements io.qt.QtEnumerator {
        TargetAutomatic(0),
        Target1D(3552),
        Target1DArray(35864),
        Target2D(3553),
        Target2DArray(35866),
        Target3D(32879),
        TargetCubeMap(34067),
        TargetCubeMapArray(36873),
        Target2DMultisample(37120),
        Target2DMultisampleArray(37122),
        TargetRectangle(34037),
        TargetBuffer(35882);

        private Target(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Target resolve(int value) {
            switch (value) {
            case 0: return TargetAutomatic;
            case 3552: return Target1D;
            case 35864: return Target1DArray;
            case 3553: return Target2D;
            case 35866: return Target2DArray;
            case 32879: return Target3D;
            case 34067: return TargetCubeMap;
            case 36873: return TargetCubeMapArray;
            case 37120: return Target2DMultisample;
            case 37122: return Target2DMultisampleArray;
            case 34037: return TargetRectangle;
            case 35882: return TargetBuffer;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::TextureFormat</a></p>
     */
    public enum TextureFormat implements io.qt.QtEnumerator {
        NoFormat(0),
        Automatic(1),
        R8_UNorm(33321),
        RG8_UNorm(33323),
        RGB8_UNorm(32849),
        RGBA8_UNorm(32856),
        R16_UNorm(33322),
        RG16_UNorm(33324),
        RGB16_UNorm(32852),
        RGBA16_UNorm(32859),
        R8_SNorm(36756),
        RG8_SNorm(36757),
        RGB8_SNorm(36758),
        RGBA8_SNorm(36759),
        R16_SNorm(36760),
        RG16_SNorm(36761),
        RGB16_SNorm(36762),
        RGBA16_SNorm(36763),
        R8U(33330),
        RG8U(33336),
        RGB8U(36221),
        RGBA8U(36220),
        R16U(33332),
        RG16U(33338),
        RGB16U(36215),
        RGBA16U(36214),
        R32U(33334),
        RG32U(33340),
        RGB32U(36209),
        RGBA32U(36208),
        R8I(33329),
        RG8I(33335),
        RGB8I(36239),
        RGBA8I(36238),
        R16I(33331),
        RG16I(33337),
        RGB16I(36233),
        RGBA16I(36232),
        R32I(33333),
        RG32I(33339),
        RGB32I(36227),
        RGBA32I(36226),
        R16F(33325),
        RG16F(33327),
        RGB16F(34843),
        RGBA16F(34842),
        R32F(33326),
        RG32F(33328),
        RGB32F(34837),
        RGBA32F(34836),
        RGB9E5(35901),
        RG11B10F(35898),
        RG3B2(10768),
        R5G6B5(36194),
        RGB5A1(32855),
        RGBA4(32854),
        RGB10A2(32857),
        RGB10A2U(36975),
        D16(33189),
        D24(33190),
        D24S8(35056),
        D32(33191),
        D32F(36012),
        D32FS8X24(36013),
        RGB_DXT1(33776),
        RGBA_DXT1(33777),
        RGBA_DXT3(33778),
        RGBA_DXT5(33779),
        R_ATI1N_UNorm(36283),
        R_ATI1N_SNorm(36284),
        RG_ATI2N_UNorm(36285),
        RG_ATI2N_SNorm(36286),
        RGB_BP_UNSIGNED_FLOAT(36495),
        RGB_BP_SIGNED_FLOAT(36494),
        RGB_BP_UNorm(36492),
        R11_EAC_UNorm(37488),
        R11_EAC_SNorm(37489),
        RG11_EAC_UNorm(37490),
        RG11_EAC_SNorm(37491),
        RGB8_ETC2(37492),
        SRGB8_ETC2(37493),
        RGB8_PunchThrough_Alpha1_ETC2(37494),
        SRGB8_PunchThrough_Alpha1_ETC2(37495),
        RGBA8_ETC2_EAC(37496),
        SRGB8_Alpha8_ETC2_EAC(37497),
        RGB8_ETC1(36196),
        SRGB8(35905),
        SRGB8_Alpha8(35907),
        SRGB_DXT1(35916),
        SRGB_Alpha_DXT1(35917),
        SRGB_Alpha_DXT3(35918),
        SRGB_Alpha_DXT5(35919),
        SRGB_BP_UNorm(36493),
        DepthFormat(6402),
        AlphaFormat(6406),
        RGBFormat(6407),
        RGBAFormat(6408),
        LuminanceFormat(6409),
        LuminanceAlphaFormat(6410);

        private TextureFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TextureFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32849: return RGB8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32852: return RGB16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36758: return RGB8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36762: return RGB16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36221: return RGB8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36215: return RGB16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36209: return RGB32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36239: return RGB8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36233: return RGB16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36227: return RGB32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34843: return RGB16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34837: return RGB32F;
            case 34836: return RGBA32F;
            case 35901: return RGB9E5;
            case 35898: return RG11B10F;
            case 10768: return RG3B2;
            case 36194: return R5G6B5;
            case 32855: return RGB5A1;
            case 32854: return RGBA4;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            case 33189: return D16;
            case 33190: return D24;
            case 35056: return D24S8;
            case 33191: return D32;
            case 36012: return D32F;
            case 36013: return D32FS8X24;
            case 33776: return RGB_DXT1;
            case 33777: return RGBA_DXT1;
            case 33778: return RGBA_DXT3;
            case 33779: return RGBA_DXT5;
            case 36283: return R_ATI1N_UNorm;
            case 36284: return R_ATI1N_SNorm;
            case 36285: return RG_ATI2N_UNorm;
            case 36286: return RG_ATI2N_SNorm;
            case 36495: return RGB_BP_UNSIGNED_FLOAT;
            case 36494: return RGB_BP_SIGNED_FLOAT;
            case 36492: return RGB_BP_UNorm;
            case 37488: return R11_EAC_UNorm;
            case 37489: return R11_EAC_SNorm;
            case 37490: return RG11_EAC_UNorm;
            case 37491: return RG11_EAC_SNorm;
            case 37492: return RGB8_ETC2;
            case 37493: return SRGB8_ETC2;
            case 37494: return RGB8_PunchThrough_Alpha1_ETC2;
            case 37495: return SRGB8_PunchThrough_Alpha1_ETC2;
            case 37496: return RGBA8_ETC2_EAC;
            case 37497: return SRGB8_Alpha8_ETC2_EAC;
            case 36196: return RGB8_ETC1;
            case 35905: return SRGB8;
            case 35907: return SRGB8_Alpha8;
            case 35916: return SRGB_DXT1;
            case 35917: return SRGB_Alpha_DXT1;
            case 35918: return SRGB_Alpha_DXT3;
            case 35919: return SRGB_Alpha_DXT5;
            case 36493: return SRGB_BP_UNorm;
            case 6402: return DepthFormat;
            case 6406: return AlphaFormat;
            case 6407: return RGBFormat;
            case 6408: return RGBAFormat;
            case 6409: return LuminanceFormat;
            case 6410: return LuminanceAlphaFormat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction-prop">Qt3DRender::QAbstractTexture::comparisonFunctionChanged(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></p>
     */
    @io.qt.QtPropertyNotify(name="comparisonFunction")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.ComparisonFunction> comparisonFunctionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode-prop">Qt3DRender::QAbstractTexture::comparisonModeChanged(Qt3DRender::QAbstractTexture::ComparisonMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="comparisonMode")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.ComparisonMode> comparisonModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth-prop">Qt3DRender::QAbstractTexture::depthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="depth")
    public final Signal1<@io.qt.QtPrimitiveType Integer> depthChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format-prop">Qt3DRender::QAbstractTexture::formatChanged(Qt3DRender::QAbstractTexture::TextureFormat)</a></p>
     */
    @io.qt.QtPropertyNotify(name="format")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.TextureFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::generateMipMapsChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="generateMipMaps")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> generateMipMapsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle-prop">Qt3DRender::QAbstractTexture::handleChanged(QVariant)</a></p>
     */
    @io.qt.QtPropertyNotify(name="handle")
    public final Signal1<java.lang.Object> handleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType-prop">Qt3DRender::QAbstractTexture::handleTypeChanged(Qt3DRender::QAbstractTexture::HandleType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="handleType")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.HandleType> handleTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height-prop">Qt3DRender::QAbstractTexture::heightChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="height")
    public final Signal1<@io.qt.QtPrimitiveType Integer> heightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers-prop">Qt3DRender::QAbstractTexture::layersChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="layers")
    public final Signal1<@io.qt.QtPrimitiveType Integer> layersChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::magnificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtPropertyNotify(name="magnificationFilter")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.Filter> magnificationFilterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy-prop">Qt3DRender::QAbstractTexture::maximumAnisotropyChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="maximumAnisotropy")
    public final Signal1<@io.qt.QtPrimitiveType Float> maximumAnisotropyChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::minificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtPropertyNotify(name="minificationFilter")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.Filter> minificationFilterChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::mipLevelsChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mipLevels")
    public final Signal1<@io.qt.QtPrimitiveType Integer> mipLevelsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples-prop">Qt3DRender::QAbstractTexture::samplesChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="samples")
    public final Signal1<@io.qt.QtPrimitiveType Integer> samplesChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status-prop">Qt3DRender::QAbstractTexture::statusChanged(Qt3DRender::QAbstractTexture::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.Status> statusChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width-prop">Qt3DRender::QAbstractTexture::widthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="width")
    public final Signal1<@io.qt.QtPrimitiveType Integer> widthChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture">Qt3DRender::QAbstractTexture::QAbstractTexture(Qt3DCore::QNode*)</a></p>
     */
    protected QAbstractTexture(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.Target, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.Target target) {
        this(target, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture-1">Qt3DRender::QAbstractTexture::QAbstractTexture(Qt3DRender::QAbstractTexture::Target,Qt3DCore::QNode*)</a></p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.Target target, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, target, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.render.QAbstractTexture.Target target, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#addTextureImage">Qt3DRender::QAbstractTexture::addTextureImage(Qt3DRender::QAbstractTextureImage*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addTextureImage(io.qt.qt3d.render.QAbstractTextureImage textureImage){
        addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @io.qt.QtUninvokable
    private native void addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction">Qt3DRender::QAbstractTexture::comparisonFunction()const</a></p>
     */
    @io.qt.QtPropertyReader(name="comparisonFunction")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.ComparisonFunction comparisonFunction(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode">Qt3DRender::QAbstractTexture::comparisonMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="comparisonMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.ComparisonMode comparisonMode(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth">Qt3DRender::QAbstractTexture::depth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="depth")
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format">Qt3DRender::QAbstractTexture::format()const</a></p>
     */
    @io.qt.QtPropertyReader(name="format")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.TextureFormat format(){
        return io.qt.qt3d.render.QAbstractTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::generateMipMaps()const</a></p>
     */
    @io.qt.QtPropertyReader(name="generateMipMaps")
    @io.qt.QtUninvokable
    public final boolean generateMipMaps(){
        return generateMipMaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean generateMipMaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle">Qt3DRender::QAbstractTexture::handle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="handle")
    @io.qt.QtUninvokable
    public final java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType">Qt3DRender::QAbstractTexture::handleType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="handleType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.HandleType handleType(){
        return io.qt.qt3d.render.QAbstractTexture.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height">Qt3DRender::QAbstractTexture::height()const</a></p>
     */
    @io.qt.QtPropertyReader(name="height")
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers">Qt3DRender::QAbstractTexture::layers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="layers")
    @io.qt.QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::magnificationFilter()const</a></p>
     */
    @io.qt.QtPropertyReader(name="magnificationFilter")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Filter magnificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy">Qt3DRender::QAbstractTexture::maximumAnisotropy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maximumAnisotropy")
    @io.qt.QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::minificationFilter()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minificationFilter")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Filter minificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::mipLevels()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mipLevels")
    @io.qt.QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#removeTextureImage">Qt3DRender::QAbstractTexture::removeTextureImage(Qt3DRender::QAbstractTextureImage*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeTextureImage(io.qt.qt3d.render.QAbstractTextureImage textureImage){
        removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @io.qt.QtUninvokable
    private native void removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples">Qt3DRender::QAbstractTexture::samples()const</a></p>
     */
    @io.qt.QtPropertyReader(name="samples")
    @io.qt.QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonFunction">Qt3DRender::QAbstractTexture::setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></p>
     */
    @io.qt.QtPropertyWriter(name="comparisonFunction")
    public final void setComparisonFunction(io.qt.qt3d.render.QAbstractTexture.ComparisonFunction function){
        setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), function.value());
    }
    
    private native void setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(long __this__nativeId, int function);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonMode">Qt3DRender::QAbstractTexture::setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="comparisonMode")
    public final void setComparisonMode(io.qt.qt3d.render.QAbstractTexture.ComparisonMode mode){
        setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setDepth">Qt3DRender::QAbstractTexture::setDepth(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="depth")
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setFormat">Qt3DRender::QAbstractTexture::setFormat(Qt3DRender::QAbstractTexture::TextureFormat)</a></p>
     */
    @io.qt.QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QAbstractTexture.TextureFormat format){
        setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setGenerateMipMaps">Qt3DRender::QAbstractTexture::setGenerateMipMaps(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="generateMipMaps")
    public final void setGenerateMipMaps(boolean gen){
        setGenerateMipMaps_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), gen);
    }
    
    private native void setGenerateMipMaps_native_bool(long __this__nativeId, boolean gen);
    
    @io.qt.QtUninvokable
    protected final void setHandle(java.lang.Object handle){
        setHandle_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), handle);
    }
    
    @io.qt.QtUninvokable
    private native void setHandle_native_cref_QVariant(long __this__nativeId, java.lang.Object handle);
    
    @io.qt.QtUninvokable
    protected final void setHandleType(io.qt.qt3d.render.QAbstractTexture.HandleType type){
        setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setHeight">Qt3DRender::QAbstractTexture::setHeight(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="height")
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setLayers">Qt3DRender::QAbstractTexture::setLayers(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="layers")
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMagnificationFilter">Qt3DRender::QAbstractTexture::setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtPropertyWriter(name="magnificationFilter")
    public final void setMagnificationFilter(io.qt.qt3d.render.QAbstractTexture.Filter f){
        setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMaximumAnisotropy">Qt3DRender::QAbstractTexture::setMaximumAnisotropy(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="maximumAnisotropy")
    public final void setMaximumAnisotropy(float anisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), anisotropy);
    }
    
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float anisotropy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMinificationFilter">Qt3DRender::QAbstractTexture::setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtPropertyWriter(name="minificationFilter")
    public final void setMinificationFilter(io.qt.qt3d.render.QAbstractTexture.Filter f){
        setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::setMipLevels(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mipLevels")
    public final void setMipLevels(int mipLevels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevels);
    }
    
    private native void setMipLevels_native_int(long __this__nativeId, int mipLevels);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSamples">Qt3DRender::QAbstractTexture::setSamples(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="samples")
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}
     *  with <code>depth = 1</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setSize(int width, int height) {
        setSize(width, height, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>height = 1</code></li>
     * <li><code>depth = 1</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void setSize(int width) {
        setSize(width, (int)1, (int)1);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSize">Qt3DRender::QAbstractTexture::setSize(int,int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSize(int width, int height, int depth){
        setSize_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @io.qt.QtUninvokable
    private native void setSize_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setStatus">Qt3DRender::QAbstractTexture::setStatus(Qt3DRender::QAbstractTexture::Status)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setStatus(io.qt.qt3d.render.QAbstractTexture.Status status){
        setStatus_native_Qt3DRender_QAbstractTexture_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @io.qt.QtUninvokable
    private native void setStatus_native_Qt3DRender_QAbstractTexture_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWidth">Qt3DRender::QAbstractTexture::setWidth(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="width")
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWrapMode">Qt3DRender::QAbstractTexture::setWrapMode(Qt3DRender::QTextureWrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWrapMode(io.qt.qt3d.render.QTextureWrapMode wrapMode){
        setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(wrapMode));
    }
    
    @io.qt.QtUninvokable
    private native void setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(long __this__nativeId, long wrapMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status">Qt3DRender::QAbstractTexture::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Status status(){
        return io.qt.qt3d.render.QAbstractTexture.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#target">Qt3DRender::QAbstractTexture::target()const</a></p>
     */
    @io.qt.QtPropertyReader(name="target")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Target target(){
        return io.qt.qt3d.render.QAbstractTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#textureImages">Qt3DRender::QAbstractTexture::textureImages()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.render.QAbstractTextureImage> textureImages(){
        return textureImages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QAbstractTextureImage> textureImages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#updateData">Qt3DRender::QAbstractTexture::updateData(Qt3DRender::QTextureDataUpdate)</a></p>
     */
    public final void updateData(io.qt.qt3d.render.QTextureDataUpdate update){
        updateData_native_cref_Qt3DRender_QTextureDataUpdate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(update));
    }
    
    private native void updateData_native_cref_Qt3DRender_QTextureDataUpdate(long __this__nativeId, long update);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width">Qt3DRender::QAbstractTexture::width()const</a></p>
     */
    @io.qt.QtPropertyReader(name="width")
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#wrapMode-prop">Qt3DRender::QAbstractTexture::wrapMode()</a></p>
     */
    @io.qt.QtPropertyReader(name="wrapMode")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode wrapMode(){
        return wrapMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QTextureWrapMode wrapMode_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractTexture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractTexture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractTexture instance, QDeclarativeConstructor constructor);
    
}
