package io.qt.qt3d.render;


/**
 * <p>Encapsulates a Shader Program</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html">Qt3DRender::QShaderProgram</a></p>
 */
public class QShaderProgram extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderProgram.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Format-enum">Qt3DRender::QShaderProgram::Format</a></p>
     */
    public enum Format implements io.qt.QtEnumerator {
        GLSL(0),
        SPIRV(1);

        private Format(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Format resolve(int value) {
            switch (value) {
            case 0: return GLSL;
            case 1: return SPIRV;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#ShaderType-enum">Qt3DRender::QShaderProgram::ShaderType</a></p>
     */
    public enum ShaderType implements io.qt.QtEnumerator {
        Vertex(0),
        Fragment(1),
        TessellationControl(2),
        TessellationEvaluation(3),
        Geometry(4),
        Compute(5);

        private ShaderType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ShaderType resolve(int value) {
            switch (value) {
            case 0: return Vertex;
            case 1: return Fragment;
            case 2: return TessellationControl;
            case 3: return TessellationEvaluation;
            case 4: return Geometry;
            case 5: return Compute;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#Status-enum">Qt3DRender::QShaderProgram::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        NotReady(0),
        Ready(1),
        Error(2);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return NotReady;
            case 1: return Ready;
            case 2: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::computeShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="computeShaderCode")
    public final Signal1<io.qt.core.QByteArray> computeShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::formatChanged(Qt3DRender::QShaderProgram::Format)</a></p>
     */
    @io.qt.QtPropertyNotify(name="format")
    public final Signal1<io.qt.qt3d.render.QShaderProgram.Format> formatChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::fragmentShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="fragmentShaderCode")
    public final Signal1<io.qt.core.QByteArray> fragmentShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::geometryShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="geometryShaderCode")
    public final Signal1<io.qt.core.QByteArray> geometryShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#log-prop">Qt3DRender::QShaderProgram::logChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="log")
    public final Signal1<java.lang.String> logChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#status-prop">Qt3DRender::QShaderProgram::statusChanged(Qt3DRender::QShaderProgram::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.render.QShaderProgram.Status> statusChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::tessellationControlShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationControlShaderCode")
    public final Signal1<io.qt.core.QByteArray> tessellationControlShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::tessellationEvaluationShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationEvaluationShaderCode")
    public final Signal1<io.qt.core.QByteArray> tessellationEvaluationShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::vertexShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexShaderCode")
    public final Signal1<io.qt.core.QByteArray> vertexShaderCodeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QShaderProgram(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderProgram() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QShaderProgram(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderProgram instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::computeShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="computeShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray computeShaderCode(){
        return computeShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray computeShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::format()const</a></p>
     */
    @io.qt.QtPropertyReader(name="format")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.Format format(){
        return io.qt.qt3d.render.QShaderProgram.Format.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::fragmentShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="fragmentShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray fragmentShaderCode(){
        return fragmentShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray fragmentShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::geometryShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="geometryShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray geometryShaderCode(){
        return geometryShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray geometryShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#log-prop">Qt3DRender::QShaderProgram::log()const</a></p>
     */
    @io.qt.QtPropertyReader(name="log")
    @io.qt.QtUninvokable
    public final java.lang.String log(){
        return log_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String log_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#computeShaderCode-prop">Qt3DRender::QShaderProgram::setComputeShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="computeShaderCode")
    public final void setComputeShaderCode(io.qt.core.QByteArray computeShaderCode){
        setComputeShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(computeShaderCode));
    }
    
    private native void setComputeShaderCode_native_cref_QByteArray(long __this__nativeId, long computeShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#format-prop">Qt3DRender::QShaderProgram::setFormat(Qt3DRender::QShaderProgram::Format)</a></p>
     */
    @io.qt.QtPropertyWriter(name="format")
    @io.qt.QtUninvokable
    public final void setFormat(io.qt.qt3d.render.QShaderProgram.Format format){
        setFormat_native_Qt3DRender_QShaderProgram_Format(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFormat_native_Qt3DRender_QShaderProgram_Format(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgram::setFragmentShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="fragmentShaderCode")
    public final void setFragmentShaderCode(io.qt.core.QByteArray fragmentShaderCode){
        setFragmentShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fragmentShaderCode));
    }
    
    private native void setFragmentShaderCode_native_cref_QByteArray(long __this__nativeId, long fragmentShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#geometryShaderCode-prop">Qt3DRender::QShaderProgram::setGeometryShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="geometryShaderCode")
    public final void setGeometryShaderCode(io.qt.core.QByteArray geometryShaderCode){
        setGeometryShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometryShaderCode));
    }
    
    private native void setGeometryShaderCode_native_cref_QByteArray(long __this__nativeId, long geometryShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#setShaderCode">Qt3DRender::QShaderProgram::setShaderCode(Qt3DRender::QShaderProgram::ShaderType,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setShaderCode(io.qt.qt3d.render.QShaderProgram.ShaderType type, io.qt.core.QByteArray shaderCode){
        setShaderCode_native_Qt3DRender_QShaderProgram_ShaderType_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(shaderCode));
    }
    
    @io.qt.QtUninvokable
    private native void setShaderCode_native_Qt3DRender_QShaderProgram_ShaderType_cref_QByteArray(long __this__nativeId, int type, long shaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::setTessellationControlShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="tessellationControlShaderCode")
    public final void setTessellationControlShaderCode(io.qt.core.QByteArray tessellationControlShaderCode){
        setTessellationControlShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationControlShaderCode));
    }
    
    private native void setTessellationControlShaderCode_native_cref_QByteArray(long __this__nativeId, long tessellationControlShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::setTessellationEvaluationShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="tessellationEvaluationShaderCode")
    public final void setTessellationEvaluationShaderCode(io.qt.core.QByteArray tessellationEvaluationShaderCode){
        setTessellationEvaluationShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationEvaluationShaderCode));
    }
    
    private native void setTessellationEvaluationShaderCode_native_cref_QByteArray(long __this__nativeId, long tessellationEvaluationShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::setVertexShaderCode(QByteArray)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexShaderCode")
    public final void setVertexShaderCode(io.qt.core.QByteArray vertexShaderCode){
        setVertexShaderCode_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vertexShaderCode));
    }
    
    private native void setVertexShaderCode_native_cref_QByteArray(long __this__nativeId, long vertexShaderCode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#shaderCode">Qt3DRender::QShaderProgram::shaderCode(Qt3DRender::QShaderProgram::ShaderType)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray shaderCode(io.qt.qt3d.render.QShaderProgram.ShaderType type){
        return shaderCode_native_Qt3DRender_QShaderProgram_ShaderType_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray shaderCode_native_Qt3DRender_QShaderProgram_ShaderType_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#status">Qt3DRender::QShaderProgram::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram.Status status(){
        return io.qt.qt3d.render.QShaderProgram.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgram::tessellationControlShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationControlShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray tessellationControlShaderCode(){
        return tessellationControlShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray tessellationControlShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgram::tessellationEvaluationShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationEvaluationShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray tessellationEvaluationShaderCode(){
        return tessellationEvaluationShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray tessellationEvaluationShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#vertexShaderCode-prop">Qt3DRender::QShaderProgram::vertexShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray vertexShaderCode(){
        return vertexShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray vertexShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qshaderprogram.html#loadSource">Qt3DRender::QShaderProgram::loadSource(QUrl)</a></p>
     */
    public static io.qt.core.QByteArray loadSource(io.qt.core.QUrl sourceUrl){
        return loadSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.checkedNativeId(sourceUrl));
    }
    
    private native static io.qt.core.QByteArray loadSource_native_cref_QUrl(long sourceUrl);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QShaderProgram(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QShaderProgram(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QShaderProgram instance, QDeclarativeConstructor constructor);
    
}
