package io.qt.qt3d.render;


/**
 * <p>Encapsulates the necessary information to create an OpenGL texture image from an image source</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html">Qt3DRender::QTextureImage</a></p>
 */
public class QTextureImage extends io.qt.qt3d.render.QAbstractTextureImage
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextureImage.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::QTextureImage::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        None(0),
        Loading(1),
        Ready(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#mirrored-prop">Qt3DRender::QTextureImage::mirroredChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mirrored")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> mirroredChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#source-prop">Qt3DRender::QTextureImage::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#status-prop">Qt3DRender::QTextureImage::statusChanged(Qt3DRender::QTextureImage::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.render.QTextureImage.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QTextureImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextureImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#QTextureImage">Qt3DRender::QTextureImage::QTextureImage(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QTextureImage(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextureImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#dataGenerator">Qt3DRender::QAbstractTextureImage::dataGenerator()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator() throws io.qt.QNoImplementationException {
        return dataGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private static io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator_native_constfct(long __this__nativeId) throws io.qt.QNoImplementationException {
        throw new io.qt.QNoImplementationException();
    }
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#isMirrored">Qt3DRender::QTextureImage::isMirrored()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mirrored")
    @io.qt.QtUninvokable
    public final boolean isMirrored(){
        return isMirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isMirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setMirrored">Qt3DRender::QTextureImage::setMirrored(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mirrored")
    public final void setMirrored(boolean mirrored){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), mirrored);
    }
    
    private native void setMirrored_native_bool(long __this__nativeId, boolean mirrored);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setSource">Qt3DRender::QTextureImage::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setStatus">Qt3DRender::QTextureImage::setStatus(Qt3DRender::QTextureImage::Status)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void setStatus(io.qt.qt3d.render.QTextureImage.Status status){
        setStatus_native_Qt3DRender_QTextureImage_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @io.qt.QtUninvokable
    private native void setStatus_native_Qt3DRender_QTextureImage_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#source">Qt3DRender::QTextureImage::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#status">Qt3DRender::QTextureImage::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QTextureImage.Status status(){
        return io.qt.qt3d.render.QTextureImage.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextureImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QTextureImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QTextureImage instance, QDeclarativeConstructor constructor);
    
}
