package io.qt.qt3d.render;


/**
 * <p>Specifies the size of rasterized points. May either be set statically or by shader programs</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html">Qt3DRender::QPointSize</a></p>
 */
public class QPointSize extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPointSize.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#SizeMode-enum">Qt3DRender::QPointSize::SizeMode</a></p>
     */
    public enum SizeMode implements io.qt.QtEnumerator {
        Fixed(0),
        Programmable(1);

        private SizeMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SizeMode resolve(int value) {
            switch (value) {
            case 0: return Fixed;
            case 1: return Programmable;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::sizeModeChanged(Qt3DRender::QPointSize::SizeMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sizeMode")
    public final Signal1<io.qt.qt3d.render.QPointSize.SizeMode> sizeModeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::valueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="value")
    public final Signal1<@io.qt.QtPrimitiveType Float> valueChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QPointSize(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPointSize() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QPointSize(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPointSize instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::setSizeMode(Qt3DRender::QPointSize::SizeMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sizeMode")
    public final void setSizeMode(io.qt.qt3d.render.QPointSize.SizeMode sizeMode){
        setSizeMode_native_Qt3DRender_QPointSize_SizeMode(QtJambi_LibraryUtilities.internal.nativeId(this), sizeMode.value());
    }
    
    private native void setSizeMode_native_Qt3DRender_QPointSize_SizeMode(long __this__nativeId, int sizeMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::setValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="value")
    public final void setValue(float value){
        setValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setValue_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::sizeMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sizeMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QPointSize.SizeMode sizeMode(){
        return io.qt.qt3d.render.QPointSize.SizeMode.resolve(sizeMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int sizeMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::value()const</a></p>
     */
    @io.qt.QtPropertyReader(name="value")
    @io.qt.QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPointSize(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPointSize(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPointSize instance, QDeclarativeConstructor constructor);
    
}
