package io.qt.qt3d.render;


/**
 * <p>Encapsulate a Point Light object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html">Qt3DRender::QPointLight</a></p>
 */
public class QPointLight extends io.qt.qt3d.render.QAbstractLight
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPointLight.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::constantAttenuationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="constantAttenuation")
    public final Signal1<@io.qt.QtPrimitiveType Float> constantAttenuationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::linearAttenuationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="linearAttenuation")
    public final Signal1<@io.qt.QtPrimitiveType Float> linearAttenuationChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::quadraticAttenuationChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="quadraticAttenuation")
    public final Signal1<@io.qt.QtPrimitiveType Float> quadraticAttenuationChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QPointLight(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPointLight() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#QPointLight">Qt3DRender::QPointLight::QPointLight(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QPointLight(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPointLight instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::constantAttenuation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="constantAttenuation")
    @io.qt.QtUninvokable
    public final float constantAttenuation(){
        return constantAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float constantAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::linearAttenuation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="linearAttenuation")
    @io.qt.QtUninvokable
    public final float linearAttenuation(){
        return linearAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float linearAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::quadraticAttenuation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="quadraticAttenuation")
    @io.qt.QtUninvokable
    public final float quadraticAttenuation(){
        return quadraticAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float quadraticAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#constantAttenuation-prop">Qt3DRender::QPointLight::setConstantAttenuation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="constantAttenuation")
    public final void setConstantAttenuation(float value){
        setConstantAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setConstantAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#linearAttenuation-prop">Qt3DRender::QPointLight::setLinearAttenuation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="linearAttenuation")
    public final void setLinearAttenuation(float value){
        setLinearAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setLinearAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpointlight.html#quadraticAttenuation-prop">Qt3DRender::QPointLight::setQuadraticAttenuation(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="quadraticAttenuation")
    public final void setQuadraticAttenuation(float value){
        setQuadraticAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setQuadraticAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPointLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPointLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPointLight instance, QDeclarativeConstructor constructor);
    
}
