package io.qt.qt3d.render;


/**
 * <p>A QAbstractTextureImage that can be written through a QPainter</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html">Qt3DRender::QPaintedTextureImage</a></p>
 */
public abstract class QPaintedTextureImage extends io.qt.qt3d.render.QAbstractTextureImage
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPaintedTextureImage.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QPaintedTextureImage {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        protected void paint(io.qt.gui.QPainter painter){
            paint_native_QPainter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
        }
        @io.qt.QtUninvokable
        private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
        
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#height-prop">Qt3DRender::QPaintedTextureImage::heightChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="height")
    public final Signal1<@io.qt.QtPrimitiveType Integer> heightChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#size-prop">Qt3DRender::QPaintedTextureImage::sizeChanged(QSize)</a></p>
     */
    @io.qt.QtPropertyNotify(name="size")
    public final Signal1<io.qt.core.QSize> sizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#width-prop">Qt3DRender::QPaintedTextureImage::widthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="width")
    public final Signal1<@io.qt.QtPrimitiveType Integer> widthChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QPaintedTextureImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPaintedTextureImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QPaintedTextureImage(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPaintedTextureImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#dataGenerator">Qt3DRender::QAbstractTextureImage::dataGenerator()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator() throws io.qt.QNoImplementationException {
        return dataGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private static io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator_native_constfct(long __this__nativeId) throws io.qt.QNoImplementationException {
        throw new io.qt.QNoImplementationException();
    }
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#height-prop">Qt3DRender::QPaintedTextureImage::height()const</a></p>
     */
    @io.qt.QtPropertyReader(name="height")
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setHeight">Qt3DRender::QPaintedTextureImage::setHeight(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="height")
    public final void setHeight(int h){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), h);
    }
    
    private native void setHeight_native_int(long __this__nativeId, int h);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setSize">Qt3DRender::QPaintedTextureImage::setSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="size")
    public final void setSize(io.qt.core.QSize size){
        setSize_native_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    private native void setSize_native_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setWidth">Qt3DRender::QPaintedTextureImage::setWidth(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="width")
    public final void setWidth(int w){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), w);
    }
    
    private native void setWidth_native_int(long __this__nativeId, int w);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#size-prop">Qt3DRender::QPaintedTextureImage::size()const</a></p>
     */
    @io.qt.QtPropertyReader(name="size")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #update(io.qt.core.QRect)}
     *  with <code>rect = new io.qt.core.QRect()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void update() {
        update(new io.qt.core.QRect());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#update">Qt3DRender::QPaintedTextureImage::update(QRect)</a></p>
     */
    @io.qt.QtUninvokable
    public final void update(io.qt.core.QRect rect){
        update_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void update_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#width-prop">Qt3DRender::QPaintedTextureImage::width()const</a></p>
     */
    @io.qt.QtPropertyReader(name="width")
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#paint">Qt3DRender::QPaintedTextureImage::paint(QPainter*)</a></p>
     */
    @io.qt.QtUninvokable
    protected abstract void paint(io.qt.gui.QPainter painter);
    
    @io.qt.QtUninvokable
    private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPaintedTextureImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPaintedTextureImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPaintedTextureImage instance, QDeclarativeConstructor constructor);
    
}
