package io.qt.qt3d.render;


/**
 * <p>Way of controlling the complexity of rendered entities based on their size on the screen</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html">Qt3DRender::QLevelOfDetail</a></p>
 */
public class QLevelOfDetail extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcCamera = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QLevelOfDetail.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#ThresholdType-enum">Qt3DRender::QLevelOfDetail::ThresholdType</a></p>
     */
    public enum ThresholdType implements io.qt.QtEnumerator {
        DistanceToCameraThreshold(0),
        ProjectedScreenPixelSizeThreshold(1);

        private ThresholdType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ThresholdType resolve(int value) {
            switch (value) {
            case 0: return DistanceToCameraThreshold;
            case 1: return ProjectedScreenPixelSizeThreshold;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#camera-prop">Qt3DRender::QLevelOfDetail::cameraChanged(QCamera*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="camera")
    public final Signal1<io.qt.qt3d.render.QCamera> cameraChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#currentIndex-prop">Qt3DRender::QLevelOfDetail::currentIndexChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="currentIndex")
    public final Signal1<@io.qt.QtPrimitiveType Integer> currentIndexChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholdType-prop">Qt3DRender::QLevelOfDetail::thresholdTypeChanged(Qt3DRender::QLevelOfDetail::ThresholdType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="thresholdType")
    public final Signal1<io.qt.qt3d.render.QLevelOfDetail.ThresholdType> thresholdTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholds-prop">Qt3DRender::QLevelOfDetail::thresholdsChanged(QList&lt;qreal&gt;)</a></p>
     */
    @io.qt.QtPropertyNotify(name="thresholds")
    public final Signal1<java.util.List<java.lang.Double>> thresholdsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::volumeOverrideChanged(Qt3DRender::QLevelOfDetailBoundingSphere)</a></p>
     */
    @io.qt.QtPropertyNotify(name="volumeOverride")
    public final Signal1<io.qt.qt3d.render.QLevelOfDetailBoundingSphere> volumeOverrideChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QLevelOfDetail(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QLevelOfDetail() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#QLevelOfDetail">Qt3DRender::QLevelOfDetail::QLevelOfDetail(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QLevelOfDetail(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QLevelOfDetail instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#camera-prop">Qt3DRender::QLevelOfDetail::camera()const</a></p>
     */
    @io.qt.QtPropertyReader(name="camera")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QCamera camera(){
        return camera_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QCamera camera_native_constfct(long __this__nativeId);
    
    public final io.qt.qt3d.render.QLevelOfDetailBoundingSphere createBoundingSphere(io.qt.gui.QVector3D center, float radius){
        return createBoundingSphere_native_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(center), radius);
    }
    
    private native io.qt.qt3d.render.QLevelOfDetailBoundingSphere createBoundingSphere_native_cref_QVector3D_float(long __this__nativeId, long center, float radius);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#currentIndex-prop">Qt3DRender::QLevelOfDetail::currentIndex()const</a></p>
     */
    @io.qt.QtPropertyReader(name="currentIndex")
    @io.qt.QtUninvokable
    public final int currentIndex(){
        return currentIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int currentIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setCamera">Qt3DRender::QLevelOfDetail::setCamera(QCamera*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="camera")
    public final void setCamera(io.qt.qt3d.render.QCamera camera){
        setCamera_native_Qt3DRender_QCamera_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(camera));
        __rcCamera = camera;
    }
    
    private native void setCamera_native_Qt3DRender_QCamera_ptr(long __this__nativeId, long camera);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setCurrentIndex">Qt3DRender::QLevelOfDetail::setCurrentIndex(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="currentIndex")
    public final void setCurrentIndex(int currentIndex){
        setCurrentIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentIndex);
    }
    
    private native void setCurrentIndex_native_int(long __this__nativeId, int currentIndex);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setThresholdType">Qt3DRender::QLevelOfDetail::setThresholdType(Qt3DRender::QLevelOfDetail::ThresholdType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="thresholdType")
    public final void setThresholdType(io.qt.qt3d.render.QLevelOfDetail.ThresholdType thresholdType){
        setThresholdType_native_Qt3DRender_QLevelOfDetail_ThresholdType(QtJambi_LibraryUtilities.internal.nativeId(this), thresholdType.value());
    }
    
    private native void setThresholdType_native_Qt3DRender_QLevelOfDetail_ThresholdType(long __this__nativeId, int thresholdType);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#setThresholds">Qt3DRender::QLevelOfDetail::setThresholds(QList&lt;qreal&gt;)</a></p>
     */
    @io.qt.QtPropertyWriter(name="thresholds")
    public final void setThresholds(java.util.Collection<java.lang.Double> thresholds){
        setThresholds_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), thresholds);
    }
    
    private native void setThresholds_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.Double> thresholds);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::setVolumeOverride(Qt3DRender::QLevelOfDetailBoundingSphere)</a></p>
     */
    @io.qt.QtPropertyWriter(name="volumeOverride")
    public final void setVolumeOverride(io.qt.qt3d.render.QLevelOfDetailBoundingSphere volumeOverride){
        setVolumeOverride_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(volumeOverride));
    }
    
    private native void setVolumeOverride_native_cref_Qt3DRender_QLevelOfDetailBoundingSphere(long __this__nativeId, long volumeOverride);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholdType-prop">Qt3DRender::QLevelOfDetail::thresholdType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="thresholdType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QLevelOfDetail.ThresholdType thresholdType(){
        return io.qt.qt3d.render.QLevelOfDetail.ThresholdType.resolve(thresholdType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int thresholdType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#thresholds-prop">Qt3DRender::QLevelOfDetail::thresholds()const</a></p>
     */
    @io.qt.QtPropertyReader(name="thresholds")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Double> thresholds(){
        return thresholds_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Double> thresholds_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qlevelofdetail.html#volumeOverride-prop">Qt3DRender::QLevelOfDetail::volumeOverride()const</a></p>
     */
    @io.qt.QtPropertyReader(name="volumeOverride")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QLevelOfDetailBoundingSphere volumeOverride(){
        return volumeOverride_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QLevelOfDetailBoundingSphere volumeOverride_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QLevelOfDetail(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QLevelOfDetail(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QLevelOfDetail instance, QDeclarativeConstructor constructor);
    
}
