package io.qt.qt3d.render;


/**
 * <p>Allows the specification of an attachment of a render target (whether it is a color texture, a depth texture, etc... )</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html">Qt3DRender::QRenderTargetOutput</a></p>
 */
public class QRenderTargetOutput extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderTargetOutput.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::QRenderTargetOutput::AttachmentPoint</a></p>
     */
    public enum AttachmentPoint implements io.qt.QtEnumerator {
        Color0(0),
        Color1(1),
        Color2(2),
        Color3(3),
        Color4(4),
        Color5(5),
        Color6(6),
        Color7(7),
        Color8(8),
        Color9(9),
        Color10(10),
        Color11(11),
        Color12(12),
        Color13(13),
        Color14(14),
        Color15(15),
        Depth(16),
        Stencil(17),
        DepthStencil(18);

        private AttachmentPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AttachmentPoint resolve(int value) {
            switch (value) {
            case 0: return Color0;
            case 1: return Color1;
            case 2: return Color2;
            case 3: return Color3;
            case 4: return Color4;
            case 5: return Color5;
            case 6: return Color6;
            case 7: return Color7;
            case 8: return Color8;
            case 9: return Color9;
            case 10: return Color10;
            case 11: return Color11;
            case 12: return Color12;
            case 13: return Color13;
            case 14: return Color14;
            case 15: return Color15;
            case 16: return Depth;
            case 17: return Stencil;
            case 18: return DepthStencil;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::attachmentPointChanged(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="attachmentPoint")
    public final Signal1<io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint> attachmentPointChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::faceChanged(Qt3DRender::QAbstractTexture::CubeMapFace)</a></p>
     */
    @io.qt.QtPropertyNotify(name="face")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture.CubeMapFace> faceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::layerChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="layer")
    public final Signal1<@io.qt.QtPrimitiveType Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::mipLevelChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mipLevel")
    public final Signal1<@io.qt.QtPrimitiveType Integer> mipLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::textureChanged(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="texture")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture> textureChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRenderTargetOutput(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderTargetOutput() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#QRenderTargetOutput">Qt3DRender::QRenderTargetOutput::QRenderTargetOutput(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderTargetOutput(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderTargetOutput instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::attachmentPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="attachmentPoint")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint attachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(attachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int attachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::face()const</a></p>
     */
    @io.qt.QtPropertyReader(name="face")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.CubeMapFace face(){
        return io.qt.qt3d.render.QAbstractTexture.CubeMapFace.resolve(face_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int face_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::layer()const</a></p>
     */
    @io.qt.QtPropertyReader(name="layer")
    @io.qt.QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::mipLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mipLevel")
    @io.qt.QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::setAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="attachmentPoint")
    public final void setAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint attachmentPoint){
        setAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), attachmentPoint.value());
    }
    
    private native void setAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int attachmentPoint);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::setFace(Qt3DRender::QAbstractTexture::CubeMapFace)</a></p>
     */
    @io.qt.QtPropertyWriter(name="face")
    public final void setFace(io.qt.qt3d.render.QAbstractTexture.CubeMapFace face){
        setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(QtJambi_LibraryUtilities.internal.nativeId(this), face.value());
    }
    
    private native void setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(long __this__nativeId, int face);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::setLayer(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::setMipLevel(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int level){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), level);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int level);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::setTexture(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="texture")
    public final void setTexture(io.qt.qt3d.render.QAbstractTexture texture){
        setTexture_native_Qt3DRender_QAbstractTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    private native void setTexture_native_Qt3DRender_QAbstractTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::texture()const</a></p>
     */
    @io.qt.QtPropertyReader(name="texture")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QAbstractTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRenderTargetOutput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRenderTargetOutput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRenderTargetOutput instance, QDeclarativeConstructor constructor);
    
}
