package io.qt.qt3d.render;


/**
 * <p>A custom mesh loader</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qmesh.html">Qt3DRender::QMesh</a></p>
 */
public class QMesh extends io.qt.qt3d.render.QGeometryRenderer
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMesh.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#Status-enum">Qt3DRender::QMesh::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        None(0),
        Loading(1),
        Ready(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::meshNameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="meshName")
    public final Signal1<java.lang.String> meshNameChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::sourceChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal1<io.qt.core.QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#status-prop">Qt3DRender::QMesh::statusChanged(Qt3DRender::QMesh::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.qt3d.render.QMesh.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMesh(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMesh() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#QMesh">Qt3DRender::QMesh::QMesh(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QMesh(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMesh instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::meshName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="meshName")
    @io.qt.QtUninvokable
    public final java.lang.String meshName(){
        return meshName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String meshName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#meshName-prop">Qt3DRender::QMesh::setMeshName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="meshName")
    public final void setMeshName(java.lang.String meshName){
        setMeshName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), meshName);
    }
    
    private native void setMeshName_native_cref_QString(long __this__nativeId, java.lang.String meshName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#source-prop">Qt3DRender::QMesh::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qmesh.html#status-prop">Qt3DRender::QMesh::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QMesh.Status status(){
        return io.qt.qt3d.render.QMesh.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMesh(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMesh(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMesh instance, QDeclarativeConstructor constructor);
    
}
