package io.qt.qt3d.render;


/**
 * <p>FrameGraphNode used to wait for a fence in the graphics command stream to become signaled</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html">Qt3DRender::QWaitFence</a></p>
 */
public class QWaitFence extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWaitFence.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QWaitFence::HandleType</p>
     */
    public enum HandleType implements io.qt.QtEnumerator {
        NoHandle(0),
        OpenGLFenceId(1);

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return OpenGLFenceId;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::handleChanged(QVariant)</a></p>
     */
    @io.qt.QtPropertyNotify(name="handle")
    public final Signal1<java.lang.Object> handleChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::handleTypeChanged(Qt3DRender::QWaitFence::HandleType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="handleType")
    public final Signal1<io.qt.qt3d.render.QWaitFence.HandleType> handleTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::timeoutChanged(quint64)</a></p>
     */
    @io.qt.QtPropertyNotify(name="timeout")
    public final Signal1<@io.qt.QtPrimitiveType Long> timeoutChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::waitOnCPUChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="waitOnCPU")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> waitOnCPUChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QWaitFence(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QWaitFence() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QWaitFence(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWaitFence instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::handle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="handle")
    @io.qt.QtUninvokable
    public final java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::handleType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="handleType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QWaitFence.HandleType handleType(){
        return io.qt.qt3d.render.QWaitFence.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::setHandle(QVariant)</a></p>
     */
    @io.qt.QtPropertyWriter(name="handle")
    @io.qt.QtUninvokable
    public final void setHandle(java.lang.Object handle){
        setHandle_native_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), handle);
    }
    
    @io.qt.QtUninvokable
    private native void setHandle_native_QVariant(long __this__nativeId, java.lang.Object handle);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::setHandleType(Qt3DRender::QWaitFence::HandleType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="handleType")
    @io.qt.QtUninvokable
    public final void setHandleType(io.qt.qt3d.render.QWaitFence.HandleType type){
        setHandleType_native_Qt3DRender_QWaitFence_HandleType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHandleType_native_Qt3DRender_QWaitFence_HandleType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::setTimeout(quint64)</a></p>
     */
    @io.qt.QtPropertyWriter(name="timeout")
    @io.qt.QtUninvokable
    public final void setTimeout(long timeout){
        setTimeout_native_unsigned_long_long(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @io.qt.QtUninvokable
    private native void setTimeout_native_unsigned_long_long(long __this__nativeId, long timeout);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::setWaitOnCPU(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="waitOnCPU")
    @io.qt.QtUninvokable
    public final void setWaitOnCPU(boolean waitOnCPU){
        setWaitOnCPU_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), waitOnCPU);
    }
    
    @io.qt.QtUninvokable
    private native void setWaitOnCPU_native_bool(long __this__nativeId, boolean waitOnCPU);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::timeout()const</a></p>
     */
    @io.qt.QtPropertyReader(name="timeout")
    @io.qt.QtUninvokable
    public final long timeout(){
        return timeout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long timeout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::waitOnCPU()const</a></p>
     */
    @io.qt.QtPropertyReader(name="waitOnCPU")
    @io.qt.QtUninvokable
    public final boolean waitOnCPU(){
        return waitOnCPU_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean waitOnCPU_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWaitFence(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QWaitFence(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QWaitFence instance, QDeclarativeConstructor constructor);
    
}
