package io.qt.qt3d.render;


/**
 * <p>Identifies the API required for the attached QTechnique</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html">Qt3DRender::QGraphicsApiFilter</a></p>
 */
public class QGraphicsApiFilter extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGraphicsApiFilter.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#Api-enum">Qt3DRender::QGraphicsApiFilter::Api</a></p>
     */
    @io.qt.QtRejectedEntries({"Vulkan"})
    public enum Api implements io.qt.QtEnumerator {
        OpenGLES(2),
        OpenGL(1),
        Vulkan(3),
        DirectX(4),
        RHI(5);

        private Api(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Api resolve(int value) {
            switch (value) {
            case 2: return OpenGLES;
            case 1: return OpenGL;
            case 4: return DirectX;
            case 5: return RHI;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#OpenGLProfile-enum">Qt3DRender::QGraphicsApiFilter::OpenGLProfile</a></p>
     */
    public enum OpenGLProfile implements io.qt.QtEnumerator {
        NoProfile(0),
        CoreProfile(1),
        CompatibilityProfile(2);

        private OpenGLProfile(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static OpenGLProfile resolve(int value) {
            switch (value) {
            case 0: return NoProfile;
            case 1: return CoreProfile;
            case 2: return CompatibilityProfile;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::apiChanged(Qt3DRender::QGraphicsApiFilter::Api)</a></p>
     */
    @io.qt.QtPropertyNotify(name="api")
    public final Signal1<io.qt.qt3d.render.QGraphicsApiFilter.Api> apiChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::extensionsChanged(QStringList)</a></p>
     */
    @io.qt.QtPropertyNotify(name="extensions")
    public final Signal1<java.util.List<java.lang.String>> extensionsChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#graphicsApiFilterChanged">Qt3DRender::QGraphicsApiFilter::graphicsApiFilterChanged()</a></p>
     */
    public final Signal0 graphicsApiFilterChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::majorVersionChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="majorVersion")
    public final Signal1<@io.qt.QtPrimitiveType Integer> majorVersionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::minorVersionChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="minorVersion")
    public final Signal1<@io.qt.QtPrimitiveType Integer> minorVersionChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::profileChanged(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)</a></p>
     */
    @io.qt.QtPropertyNotify(name="profile")
    public final Signal1<io.qt.qt3d.render.QGraphicsApiFilter.OpenGLProfile> profileChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::vendorChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vendor")
    public final Signal1<java.lang.String> vendorChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGraphicsApiFilter(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QGraphicsApiFilter() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#QGraphicsApiFilter">Qt3DRender::QGraphicsApiFilter::QGraphicsApiFilter(QObject*)</a></p>
     */
    public QGraphicsApiFilter(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGraphicsApiFilter instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::api()const</a></p>
     */
    @io.qt.QtPropertyReader(name="api")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.Api api(){
        return io.qt.qt3d.render.QGraphicsApiFilter.Api.resolve(api_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int api_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::extensions()const</a></p>
     */
    @io.qt.QtPropertyReader(name="extensions")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList extensions(){
        return extensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList extensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::majorVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="majorVersion")
    @io.qt.QtUninvokable
    public final int majorVersion(){
        return majorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int majorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::minorVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minorVersion")
    @io.qt.QtUninvokable
    public final int minorVersion(){
        return minorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int minorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::profile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="profile")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGraphicsApiFilter.OpenGLProfile profile(){
        return io.qt.qt3d.render.QGraphicsApiFilter.OpenGLProfile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#api-prop">Qt3DRender::QGraphicsApiFilter::setApi(Qt3DRender::QGraphicsApiFilter::Api)</a></p>
     */
    @io.qt.QtPropertyWriter(name="api")
    public final void setApi(io.qt.qt3d.render.QGraphicsApiFilter.Api api){
        setApi_native_Qt3DRender_QGraphicsApiFilter_Api(QtJambi_LibraryUtilities.internal.nativeId(this), api.value());
    }
    
    private native void setApi_native_Qt3DRender_QGraphicsApiFilter_Api(long __this__nativeId, int api);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#extensions-prop">Qt3DRender::QGraphicsApiFilter::setExtensions(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="extensions")
    public final void setExtensions(java.util.Collection<java.lang.String> extensions){
        setExtensions_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), extensions);
    }
    
    private native void setExtensions_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> extensions);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#majorVersion-prop">Qt3DRender::QGraphicsApiFilter::setMajorVersion(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="majorVersion")
    public final void setMajorVersion(int majorVersion){
        setMajorVersion_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), majorVersion);
    }
    
    private native void setMajorVersion_native_int(long __this__nativeId, int majorVersion);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#minorVersion-prop">Qt3DRender::QGraphicsApiFilter::setMinorVersion(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="minorVersion")
    public final void setMinorVersion(int minorVersion){
        setMinorVersion_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), minorVersion);
    }
    
    private native void setMinorVersion_native_int(long __this__nativeId, int minorVersion);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#profile-prop">Qt3DRender::QGraphicsApiFilter::setProfile(Qt3DRender::QGraphicsApiFilter::OpenGLProfile)</a></p>
     */
    @io.qt.QtPropertyWriter(name="profile")
    public final void setProfile(io.qt.qt3d.render.QGraphicsApiFilter.OpenGLProfile profile){
        setProfile_native_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(QtJambi_LibraryUtilities.internal.nativeId(this), profile.value());
    }
    
    private native void setProfile_native_Qt3DRender_QGraphicsApiFilter_OpenGLProfile(long __this__nativeId, int profile);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::setVendor(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vendor")
    public final void setVendor(java.lang.String vendor){
        setVendor_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), vendor);
    }
    
    private native void setVendor_native_cref_QString(long __this__nativeId, java.lang.String vendor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qgraphicsapifilter.html#vendor-prop">Qt3DRender::QGraphicsApiFilter::vendor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vendor")
    @io.qt.QtUninvokable
    public final java.lang.String vendor(){
        return vendor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String vendor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGraphicsApiFilter(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QGraphicsApiFilter(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QGraphicsApiFilter instance, QDeclarativeConstructor constructor);
    
}
