package io.qt.qt3d.render;


/**
 * <p>Stores texture information such as the target, height, width, depth, layers, wrap, and if mipmaps are enabled</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html">Qt3DRender::QTextureData</a></p>
 */
public class QTextureData extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#QTextureData">Qt3DRender::QTextureData::QTextureData()</a></p>
     */
    public QTextureData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTextureData instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#addImageData">Qt3DRender::QTextureData::addImageData(Qt3DRender::QTextureImageDataPtr)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addImageData(io.qt.qt3d.render.QTextureImageData imageData){
        addImageData_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), imageData);
    }
    
    @io.qt.QtUninvokable
    private native void addImageData_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.render.QTextureImageData imageData);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#comparisonFunction">Qt3DRender::QTextureData::comparisonFunction()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.ComparisonFunction comparisonFunction(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#comparisonMode">Qt3DRender::QTextureData::comparisonMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.ComparisonMode comparisonMode(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#depth">Qt3DRender::QTextureData::depth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#format">Qt3DRender::QTextureData::format()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.TextureFormat format(){
        return io.qt.qt3d.render.QAbstractTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#height">Qt3DRender::QTextureData::height()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#imageData">Qt3DRender::QTextureData::imageData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.util.List<QTextureImageData> imageData(){
        return imageData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<QTextureImageData> imageData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#isAutoMipMapGenerationEnabled">Qt3DRender::QTextureData::isAutoMipMapGenerationEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAutoMipMapGenerationEnabled(){
        return isAutoMipMapGenerationEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAutoMipMapGenerationEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#layers">Qt3DRender::QTextureData::layers()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#magnificationFilter">Qt3DRender::QTextureData::magnificationFilter()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Filter magnificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#maximumAnisotropy">Qt3DRender::QTextureData::maximumAnisotropy()const</a></p>
     */
    @io.qt.QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#minificationFilter">Qt3DRender::QTextureData::minificationFilter()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Filter minificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setAutoMipMapGenerationEnabled">Qt3DRender::QTextureData::setAutoMipMapGenerationEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAutoMipMapGenerationEnabled(boolean isAutoMipMapGenerationEnabled){
        setAutoMipMapGenerationEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isAutoMipMapGenerationEnabled);
    }
    
    @io.qt.QtUninvokable
    private native void setAutoMipMapGenerationEnabled_native_bool(long __this__nativeId, boolean isAutoMipMapGenerationEnabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setComparisonFunction">Qt3DRender::QTextureData::setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setComparisonFunction(io.qt.qt3d.render.QAbstractTexture.ComparisonFunction comparisonFunction){
        setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), comparisonFunction.value());
    }
    
    @io.qt.QtUninvokable
    private native void setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(long __this__nativeId, int comparisonFunction);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setComparisonMode">Qt3DRender::QTextureData::setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setComparisonMode(io.qt.qt3d.render.QAbstractTexture.ComparisonMode comparisonMode){
        setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), comparisonMode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(long __this__nativeId, int comparisonMode);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setDepth">Qt3DRender::QTextureData::setDepth(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @io.qt.QtUninvokable
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setFormat">Qt3DRender::QTextureData::setFormat(Qt3DRender::QAbstractTexture::TextureFormat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFormat(io.qt.qt3d.render.QAbstractTexture.TextureFormat arg__1){
        setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setHeight">Qt3DRender::QTextureData::setHeight(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    @io.qt.QtUninvokable
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setLayers">Qt3DRender::QTextureData::setLayers(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    @io.qt.QtUninvokable
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMagnificationFilter">Qt3DRender::QTextureData::setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMagnificationFilter(io.qt.qt3d.render.QAbstractTexture.Filter filter){
        setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMaximumAnisotropy">Qt3DRender::QTextureData::setMaximumAnisotropy(float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMaximumAnisotropy(float maximumAnisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), maximumAnisotropy);
    }
    
    @io.qt.QtUninvokable
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float maximumAnisotropy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMinificationFilter">Qt3DRender::QTextureData::setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMinificationFilter(io.qt.qt3d.render.QAbstractTexture.Filter filter){
        setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setTarget">Qt3DRender::QTextureData::setTarget(Qt3DRender::QAbstractTexture::Target)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTarget(io.qt.qt3d.render.QAbstractTexture.Target target){
        setTarget_native_Qt3DRender_QAbstractTexture_Target(QtJambi_LibraryUtilities.internal.nativeId(this), target.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTarget_native_Qt3DRender_QAbstractTexture_Target(long __this__nativeId, int target);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWidth">Qt3DRender::QTextureData::setWidth(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @io.qt.QtUninvokable
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeX">Qt3DRender::QTextureData::setWrapModeX(Qt3DRender::QTextureWrapMode::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWrapModeX(io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeX){
        setWrapModeX_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeX.value());
    }
    
    @io.qt.QtUninvokable
    private native void setWrapModeX_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeX);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeY">Qt3DRender::QTextureData::setWrapModeY(Qt3DRender::QTextureWrapMode::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWrapModeY(io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeY){
        setWrapModeY_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeY.value());
    }
    
    @io.qt.QtUninvokable
    private native void setWrapModeY_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeY);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeZ">Qt3DRender::QTextureData::setWrapModeZ(Qt3DRender::QTextureWrapMode::WrapMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWrapModeZ(io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeZ){
        setWrapModeZ_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeZ.value());
    }
    
    @io.qt.QtUninvokable
    private native void setWrapModeZ_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeZ);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#target">Qt3DRender::QTextureData::target()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.Target target(){
        return io.qt.qt3d.render.QAbstractTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#width">Qt3DRender::QTextureData::width()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeX">Qt3DRender::QTextureData::wrapModeX()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeX(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int wrapModeX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeY">Qt3DRender::QTextureData::wrapModeY()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeY(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int wrapModeY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeZ">Qt3DRender::QTextureData::wrapModeZ()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.WrapMode wrapModeZ(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int wrapModeZ_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextureData(QPrivateConstructor p) { super(p); } 
    
}
