package io.qt.qt3d.render;


/**
 * <p>Holds information when an object is picked</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html">Qt3DRender::QPickEvent</a></p>
 */
public class QPickEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Buttons-enum">Qt3DRender::QPickEvent::Buttons</a></p>
     */
    public enum Buttons implements io.qt.QtEnumerator {
        LeftButton(1),
        RightButton(2),
        MiddleButton(4),
        BackButton(8),
        NoButton(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Buttons(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Buttons resolve(int value) {
            switch (value) {
            case 1: return LeftButton;
            case 2: return RightButton;
            case 4: return MiddleButton;
            case 8: return BackButton;
            case 0: return NoButton;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#Modifiers-enum">Qt3DRender::QPickEvent::Modifiers</a></p>
     */
    public enum Modifiers implements io.qt.QtEnumerator {
        NoModifier(0),
        ShiftModifier(33554432),
        ControlModifier(67108864),
        AltModifier(134217728),
        MetaModifier(268435456),
        KeypadModifier(536870912);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Modifiers(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Modifiers resolve(int value) {
            switch (value) {
            case 0: return NoModifier;
            case 33554432: return ShiftModifier;
            case 67108864: return ControlModifier;
            case 134217728: return AltModifier;
            case 268435456: return MetaModifier;
            case 536870912: return KeypadModifier;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#accepted-prop">Qt3DRender::QPickEvent::acceptedChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="accepted")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> acceptedChanged = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent">Qt3DRender::QPickEvent::QPickEvent()</a></p>
     */
    public QPickEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPickEvent instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent-1">Qt3DRender::QPickEvent::QPickEvent(QPointF,QVector3D,QVector3D,float)</a></p>
     */
    public QPickEvent(io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance);
    }
    
    private native static void initialize_native(QPickEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#QPickEvent-2">Qt3DRender::QPickEvent::QPickEvent(QPointF,QVector3D,QVector3D,float,Qt3DRender::QPickEvent::Buttons,int,int)</a></p>
     */
    public QPickEvent(io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, button, buttons, modifiers);
    }
    
    private native static void initialize_native(QPickEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers);
    
    /**
     * <p>QPickEvent::button Returns mouse button that caused the event</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#button">Qt3DRender::QPickEvent::button()const</a></p>
     */
    @io.qt.QtPropertyReader(name="button")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QPickEvent.Buttons button(){
        return io.qt.qt3d.render.QPickEvent.Buttons.resolve(button_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int button_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::buttons Returns bitfield to be used to check for mouse buttons that may be accompanying the pick event</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#buttons">Qt3DRender::QPickEvent::buttons()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buttons")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::distance Returns distance from camera to pick point</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#distance">Qt3DRender::QPickEvent::distance()const</a></p>
     */
    @io.qt.QtPropertyReader(name="distance")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final float distance(){
        return distance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float distance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#entity-prop">Qt3DRender::QPickEvent::entity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="entity")
    @io.qt.QtPropertyConstant
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.core.QEntity entity(){
        return entity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QEntity entity_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::isAccepted Returns true if the event has been accepted</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#isAccepted">Qt3DRender::QPickEvent::isAccepted()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accepted")
    @io.qt.QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::localIntersection Returns coordinates of the hit in the local coordinate system of the picked entity</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#localIntersection">Qt3DRender::QPickEvent::localIntersection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="localIntersection")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D localIntersection(){
        return localIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D localIntersection_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::modifiers Returns bitfield to be used to check for keyboard modifiers that may be accompanying the pick event</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#modifiers">Qt3DRender::QPickEvent::modifiers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="modifiers")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int modifiers(){
        return modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::position Returns mouse pointer coordinate of the pick query</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#position">Qt3DRender::QPickEvent::position()const</a></p>
     */
    @io.qt.QtPropertyReader(name="position")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF position_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::setAccepted set if the event has been accepted to accepted</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#setAccepted">Qt3DRender::QPickEvent::setAccepted(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accepted")
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#viewport-prop">Qt3DRender::QPickEvent::viewport()const</a></p>
     */
    @io.qt.QtPropertyReader(name="viewport")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QViewport viewport(){
        return viewport_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QViewport viewport_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickEvent::worldIntersection Returns coordinates of the hit in world coordinate system</p>
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qpickevent.html#worldIntersection">Qt3DRender::QPickEvent::worldIntersection()const</a></p>
     */
    @io.qt.QtPropertyReader(name="worldIntersection")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D worldIntersection(){
        return worldIntersection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D worldIntersection_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPickEvent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPickEvent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPickEvent instance, QDeclarativeConstructor constructor);
    
}
