package io.qt.qt3d.render;


/**
 * <p>Holds settings related to available rendering engines</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html">Qt3DRender::QRenderCapabilities</a></p>
 */
public class QRenderCapabilities extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderCapabilities.class);
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QRenderCapabilities::API</p>
     */
    public enum API implements io.qt.QtEnumerator {
        OpenGL(1),
        OpenGLES(2),
        Vulkan(3),
        DirectX(4),
        RHI(5);

        private API(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static API resolve(int value) {
            switch (value) {
            case 1: return OpenGL;
            case 2: return OpenGLES;
            case 3: return Vulkan;
            case 4: return DirectX;
            case 5: return RHI;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum Qt3DRender::QRenderCapabilities::Profile</p>
     */
    public enum Profile implements io.qt.QtEnumerator {
        NoProfile(0),
        CoreProfile(1),
        CompatibilityProfile(2);

        private Profile(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Profile resolve(int value) {
            switch (value) {
            case 0: return NoProfile;
            case 1: return CoreProfile;
            case 2: return CompatibilityProfile;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderCapabilities(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderCapabilities() {
        this((io.qt.core.QObject)null);
    }
    
    public QRenderCapabilities(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderCapabilities instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#api-prop">Qt3DRender::QRenderCapabilities::api()const</a></p>
     */
    @io.qt.QtPropertyReader(name="api")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.API api(){
        return io.qt.qt3d.render.QRenderCapabilities.API.resolve(api_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int api_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#driverVersion-prop">Qt3DRender::QRenderCapabilities::driverVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="driverVersion")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String driverVersion(){
        return driverVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String driverVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#extensions-prop">Qt3DRender::QRenderCapabilities::extensions()const</a></p>
     */
    @io.qt.QtPropertyReader(name="extensions")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList extensions(){
        return extensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList extensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#glslVersion-prop">Qt3DRender::QRenderCapabilities::glslVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="glslVersion")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String glslVersion(){
        return glslVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String glslVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#valid-prop">Qt3DRender::QRenderCapabilities::isValid()const</a></p>
     */
    @io.qt.QtPropertyReader(name="valid")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#majorVersion-prop">Qt3DRender::QRenderCapabilities::majorVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="majorVersion")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int majorVersion(){
        return majorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int majorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxComputeInvocations-prop">Qt3DRender::QRenderCapabilities::maxComputeInvocations()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxComputeInvocations")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxComputeInvocations(){
        return maxComputeInvocations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxComputeInvocations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxComputeSharedMemorySize-prop">Qt3DRender::QRenderCapabilities::maxComputeSharedMemorySize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxComputeSharedMemorySize")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxComputeSharedMemorySize(){
        return maxComputeSharedMemorySize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxComputeSharedMemorySize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxImageUnits-prop">Qt3DRender::QRenderCapabilities::maxImageUnits()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxImageUnits")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxImageUnits(){
        return maxImageUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxImageUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxSSBOBindings-prop">Qt3DRender::QRenderCapabilities::maxSSBOBindings()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxSSBOBindings")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxSSBOBindings(){
        return maxSSBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxSSBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxSSBOSize-prop">Qt3DRender::QRenderCapabilities::maxSSBOSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxSSBOSize")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxSSBOSize(){
        return maxSSBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxSSBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxSamples-prop">Qt3DRender::QRenderCapabilities::maxSamples()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxSamples")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxSamples(){
        return maxSamples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxSamples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxTextureLayers-prop">Qt3DRender::QRenderCapabilities::maxTextureLayers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxTextureLayers")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxTextureLayers(){
        return maxTextureLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxTextureLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxTextureSize-prop">Qt3DRender::QRenderCapabilities::maxTextureSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxTextureSize")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxTextureSize(){
        return maxTextureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxTextureSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxTextureUnits-prop">Qt3DRender::QRenderCapabilities::maxTextureUnits()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxTextureUnits")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxTextureUnits(){
        return maxTextureUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxTextureUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxUBOBindings-prop">Qt3DRender::QRenderCapabilities::maxUBOBindings()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxUBOBindings")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxUBOBindings(){
        return maxUBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxUBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxUBOSize-prop">Qt3DRender::QRenderCapabilities::maxUBOSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxUBOSize")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxUBOSize(){
        return maxUBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxUBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupCountX-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupCountX")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupCountX(){
        return maxWorkGroupCountX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupCountX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupCountY-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupCountY")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupCountY(){
        return maxWorkGroupCountY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupCountY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupCountZ-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupCountZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupCountZ")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupCountZ(){
        return maxWorkGroupCountZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupCountZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupSizeX-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeX()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupSizeX")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupSizeX(){
        return maxWorkGroupSizeX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupSizeX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupSizeY-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeY()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupSizeY")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupSizeY(){
        return maxWorkGroupSizeY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupSizeY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#maxWorkGroupSizeZ-prop">Qt3DRender::QRenderCapabilities::maxWorkGroupSizeZ()const</a></p>
     */
    @io.qt.QtPropertyReader(name="maxWorkGroupSizeZ")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int maxWorkGroupSizeZ(){
        return maxWorkGroupSizeZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int maxWorkGroupSizeZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#minorVersion-prop">Qt3DRender::QRenderCapabilities::minorVersion()const</a></p>
     */
    @io.qt.QtPropertyReader(name="minorVersion")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int minorVersion(){
        return minorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int minorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#profile-prop">Qt3DRender::QRenderCapabilities::profile()const</a></p>
     */
    @io.qt.QtPropertyReader(name="profile")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.Profile profile(){
        return io.qt.qt3d.render.QRenderCapabilities.Profile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#renderer-prop">Qt3DRender::QRenderCapabilities::renderer()const</a></p>
     */
    @io.qt.QtPropertyReader(name="renderer")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#supportsCompute-prop">Qt3DRender::QRenderCapabilities::supportsCompute()const</a></p>
     */
    @io.qt.QtPropertyReader(name="supportsCompute")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean supportsCompute(){
        return supportsCompute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsCompute_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#supportsImageStore-prop">Qt3DRender::QRenderCapabilities::supportsImageStore()const</a></p>
     */
    @io.qt.QtPropertyReader(name="supportsImageStore")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean supportsImageStore(){
        return supportsImageStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsImageStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#supportsSSBO-prop">Qt3DRender::QRenderCapabilities::supportsSSBO()const</a></p>
     */
    @io.qt.QtPropertyReader(name="supportsSSBO")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean supportsSSBO(){
        return supportsSSBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsSSBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#supportsUBO-prop">Qt3DRender::QRenderCapabilities::supportsUBO()const</a></p>
     */
    @io.qt.QtPropertyReader(name="supportsUBO")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean supportsUBO(){
        return supportsUBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean supportsUBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qrendercapabilities.html#vendor-prop">Qt3DRender::QRenderCapabilities::vendor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vendor")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String vendor(){
        return vendor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String vendor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRenderCapabilities(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRenderCapabilities(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRenderCapabilities instance, QDeclarativeConstructor constructor);
    
}
