package io.qt.qt3d.render;


/**
 * <p>Specifies how entity picking is handled</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html">Qt3DRender::QPickingSettings</a></p>
 */
public class QPickingSettings extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickingSettings.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#FaceOrientationPickingMode-enum">Qt3DRender::QPickingSettings::FaceOrientationPickingMode</a></p>
     */
    public enum FaceOrientationPickingMode implements io.qt.QtEnumerator {
        FrontFace(1),
        BackFace(2),
        FrontAndBackFace(3);

        private FaceOrientationPickingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FaceOrientationPickingMode resolve(int value) {
            switch (value) {
            case 1: return FrontFace;
            case 2: return BackFace;
            case 3: return FrontAndBackFace;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#PickMethod-enum">Qt3DRender::QPickingSettings::PickMethod</a></p>
     */
    public enum PickMethod implements io.qt.QtEnumerator {
        BoundingVolumePicking(0),
        TrianglePicking(1),
        LinePicking(2),
        PointPicking(4),
        PrimitivePicking(7);

        private PickMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PickMethod resolve(int value) {
            switch (value) {
            case 0: return BoundingVolumePicking;
            case 1: return TrianglePicking;
            case 2: return LinePicking;
            case 4: return PointPicking;
            case 7: return PrimitivePicking;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#PickResultMode-enum">Qt3DRender::QPickingSettings::PickResultMode</a></p>
     */
    public enum PickResultMode implements io.qt.QtEnumerator {
        NearestPick(0),
        AllPicks(1),
        NearestPriorityPick(2);

        private PickResultMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PickResultMode resolve(int value) {
            switch (value) {
            case 0: return NearestPick;
            case 1: return AllPicks;
            case 2: return NearestPriorityPick;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::faceOrientationPickingModeChanged(Qt3DRender::QPickingSettings::FaceOrientationPickingMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="faceOrientationPickingMode")
    public final Signal1<io.qt.qt3d.render.QPickingSettings.FaceOrientationPickingMode> faceOrientationPickingModeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::pickMethodChanged(Qt3DRender::QPickingSettings::PickMethod)</a></p>
     */
    @io.qt.QtPropertyNotify(name="pickMethod")
    public final Signal1<io.qt.qt3d.render.QPickingSettings.PickMethod> pickMethodChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::pickResultModeChanged(Qt3DRender::QPickingSettings::PickResultMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="pickResultMode")
    public final Signal1<io.qt.qt3d.render.QPickingSettings.PickResultMode> pickResultModeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#worldSpaceTolerance-prop">Qt3DRender::QPickingSettings::worldSpaceToleranceChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="worldSpaceTolerance")
    public final Signal1<@io.qt.QtPrimitiveType Float> worldSpaceToleranceChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QPickingSettings(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPickingSettings() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QPickingSettings(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPickingSettings instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::faceOrientationPickingMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="faceOrientationPickingMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.FaceOrientationPickingMode faceOrientationPickingMode(){
        return io.qt.qt3d.render.QPickingSettings.FaceOrientationPickingMode.resolve(faceOrientationPickingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int faceOrientationPickingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::pickMethod()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pickMethod")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.PickMethod pickMethod(){
        return io.qt.qt3d.render.QPickingSettings.PickMethod.resolve(pickMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pickMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::pickResultMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pickResultMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QPickingSettings.PickResultMode pickResultMode(){
        return io.qt.qt3d.render.QPickingSettings.PickResultMode.resolve(pickResultMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pickResultMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#faceOrientationPickingMode-prop">Qt3DRender::QPickingSettings::setFaceOrientationPickingMode(Qt3DRender::QPickingSettings::FaceOrientationPickingMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="faceOrientationPickingMode")
    public final void setFaceOrientationPickingMode(io.qt.qt3d.render.QPickingSettings.FaceOrientationPickingMode faceOrientationPickingMode){
        setFaceOrientationPickingMode_native_Qt3DRender_QPickingSettings_FaceOrientationPickingMode(QtJambi_LibraryUtilities.internal.nativeId(this), faceOrientationPickingMode.value());
    }
    
    private native void setFaceOrientationPickingMode_native_Qt3DRender_QPickingSettings_FaceOrientationPickingMode(long __this__nativeId, int faceOrientationPickingMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickMethod-prop">Qt3DRender::QPickingSettings::setPickMethod(Qt3DRender::QPickingSettings::PickMethod)</a></p>
     */
    @io.qt.QtPropertyWriter(name="pickMethod")
    public final void setPickMethod(io.qt.qt3d.render.QPickingSettings.PickMethod pickMethod){
        setPickMethod_native_Qt3DRender_QPickingSettings_PickMethod(QtJambi_LibraryUtilities.internal.nativeId(this), pickMethod.value());
    }
    
    private native void setPickMethod_native_Qt3DRender_QPickingSettings_PickMethod(long __this__nativeId, int pickMethod);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#pickResultMode-prop">Qt3DRender::QPickingSettings::setPickResultMode(Qt3DRender::QPickingSettings::PickResultMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="pickResultMode")
    public final void setPickResultMode(io.qt.qt3d.render.QPickingSettings.PickResultMode pickResultMode){
        setPickResultMode_native_Qt3DRender_QPickingSettings_PickResultMode(QtJambi_LibraryUtilities.internal.nativeId(this), pickResultMode.value());
    }
    
    private native void setPickResultMode_native_Qt3DRender_QPickingSettings_PickResultMode(long __this__nativeId, int pickResultMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#setWorldSpaceTolerance">Qt3DRender::QPickingSettings::setWorldSpaceTolerance(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="worldSpaceTolerance")
    public final void setWorldSpaceTolerance(float worldSpaceTolerance){
        setWorldSpaceTolerance_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), worldSpaceTolerance);
    }
    
    private native void setWorldSpaceTolerance_native_float(long __this__nativeId, float worldSpaceTolerance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qpickingsettings.html#worldSpaceTolerance">Qt3DRender::QPickingSettings::worldSpaceTolerance()const</a></p>
     */
    @io.qt.QtPropertyReader(name="worldSpaceTolerance")
    @io.qt.QtUninvokable
    public final float worldSpaceTolerance(){
        return worldSpaceTolerance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float worldSpaceTolerance_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QPickingSettings(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QPickingSettings(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QPickingSettings instance, QDeclarativeConstructor constructor);
    
}
