package io.qt.qt3d.render;


/**
 * <p>Stores data representing a texture</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html">Qt3DRender::QTextureImageData</a></p>
 */
public class QTextureImageData extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#QTextureImageData">Qt3DRender::QTextureImageData::QTextureImageData()</a></p>
     */
    public QTextureImageData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTextureImageData instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#cleanup">Qt3DRender::QTextureImageData::cleanup()</a></p>
     */
    @io.qt.QtUninvokable
    public final void cleanup(){
        cleanup_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void cleanup_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}
     *  with <code>mipmapLevel = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data(int layer, int face) {
        return data(layer, face, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>face = 0</code></li>
     * <li><code>mipmapLevel = 0</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data(int layer) {
        return data(layer, (int)0, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>layer = 0</code></li>
     * <li><code>face = 0</code></li>
     * <li><code>mipmapLevel = 0</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data() {
        return data((int)0, (int)0, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#data">Qt3DRender::QTextureImageData::data(int,int,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data(int layer, int face, int mipmapLevel){
        return data_native_int_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), layer, face, mipmapLevel);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray data_native_int_int_int_constfct(long __this__nativeId, int layer, int face, int mipmapLevel);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#depth">Qt3DRender::QTextureImageData::depth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#faces">Qt3DRender::QTextureImageData::faces()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int faces(){
        return faces_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int faces_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#format">Qt3DRender::QTextureImageData::format()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLTexture.TextureFormat format(){
        return io.qt.gui.QOpenGLTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#height">Qt3DRender::QTextureImageData::height()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#isCompressed">Qt3DRender::QTextureImageData::isCompressed()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isCompressed(){
        return isCompressed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCompressed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#layers">Qt3DRender::QTextureImageData::layers()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#mipLevels">Qt3DRender::QTextureImageData::mipLevels()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#pixelFormat">Qt3DRender::QTextureImageData::pixelFormat()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLTexture.PixelFormat pixelFormat(){
        return io.qt.gui.QOpenGLTexture.PixelFormat.resolve(pixelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pixelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#pixelType">Qt3DRender::QTextureImageData::pixelType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLTexture.PixelType pixelType(){
        return io.qt.gui.QOpenGLTexture.PixelType.resolve(pixelType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int pixelType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.core.QByteArray, int, boolean)}
     *  with <code>isCompressed = false</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setData(io.qt.core.QByteArray data, int blockSize) {
        setData(data, blockSize, (boolean)false);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setData">Qt3DRender::QTextureImageData::setData(QByteArray,int,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setData(io.qt.core.QByteArray data, int blockSize, boolean isCompressed){
        setData_native_cref_QByteArray_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), blockSize, isCompressed);
    }
    
    @io.qt.QtUninvokable
    private native void setData_native_cref_QByteArray_int_bool(long __this__nativeId, long data, int blockSize, boolean isCompressed);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setDepth">Qt3DRender::QTextureImageData::setDepth(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @io.qt.QtUninvokable
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setFaces">Qt3DRender::QTextureImageData::setFaces(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFaces(int faces){
        setFaces_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), faces);
    }
    
    @io.qt.QtUninvokable
    private native void setFaces_native_int(long __this__nativeId, int faces);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setFormat">Qt3DRender::QTextureImageData::setFormat(QOpenGLTexture::TextureFormat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFormat(io.qt.gui.QOpenGLTexture.TextureFormat format){
        setFormat_native_QOpenGLTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFormat_native_QOpenGLTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setHeight">Qt3DRender::QTextureImageData::setHeight(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    @io.qt.QtUninvokable
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setImage">Qt3DRender::QTextureImageData::setImage(QImage)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setImage(io.qt.gui.QImage arg__1){
        setImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setImage_native_cref_QImage(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setLayers">Qt3DRender::QTextureImageData::setLayers(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    @io.qt.QtUninvokable
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setMipLevels">Qt3DRender::QTextureImageData::setMipLevels(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMipLevels(int mipLevels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevels);
    }
    
    @io.qt.QtUninvokable
    private native void setMipLevels_native_int(long __this__nativeId, int mipLevels);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setPixelFormat">Qt3DRender::QTextureImageData::setPixelFormat(QOpenGLTexture::PixelFormat)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPixelFormat(io.qt.gui.QOpenGLTexture.PixelFormat pixelFormat){
        setPixelFormat_native_QOpenGLTexture_PixelFormat(QtJambi_LibraryUtilities.internal.nativeId(this), pixelFormat.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPixelFormat_native_QOpenGLTexture_PixelFormat(long __this__nativeId, int pixelFormat);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setPixelType">Qt3DRender::QTextureImageData::setPixelType(QOpenGLTexture::PixelType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPixelType(io.qt.gui.QOpenGLTexture.PixelType pixelType){
        setPixelType_native_QOpenGLTexture_PixelType(QtJambi_LibraryUtilities.internal.nativeId(this), pixelType.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPixelType_native_QOpenGLTexture_PixelType(long __this__nativeId, int pixelType);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setTarget">Qt3DRender::QTextureImageData::setTarget(QOpenGLTexture::Target)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setTarget(io.qt.gui.QOpenGLTexture.Target target){
        setTarget_native_QOpenGLTexture_Target(QtJambi_LibraryUtilities.internal.nativeId(this), target.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTarget_native_QOpenGLTexture_Target(long __this__nativeId, int target);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#setWidth">Qt3DRender::QTextureImageData::setWidth(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @io.qt.QtUninvokable
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#target">Qt3DRender::QTextureImageData::target()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLTexture.Target target(){
        return io.qt.gui.QOpenGLTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qtextureimagedata.html#width">Qt3DRender::QTextureImageData::width()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextureImageData(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if(other instanceof io.qt.qt3d.render.QTextureImageData)
            return hashCode()==other.hashCode();
        else return super.equals(other);    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QTextureImageData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QTextureImageData clone_native(long __this_nativeId);
}
