package io.qt.qt3d.render;


/**
 * <p>Encapsulates geometry rendering</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html">Qt3DRender::QGeometryRenderer</a></p>
 */
public class QGeometryRenderer extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGeometryRenderer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::PrimitiveType</a></p>
     */
    public enum PrimitiveType implements io.qt.QtEnumerator {
        Points(0),
        Lines(1),
        LineLoop(2),
        LineStrip(3),
        Triangles(4),
        TriangleStrip(5),
        TriangleFan(6),
        LinesAdjacency(10),
        TrianglesAdjacency(12),
        LineStripAdjacency(11),
        TriangleStripAdjacency(13),
        Patches(14);

        private PrimitiveType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PrimitiveType resolve(int value) {
            switch (value) {
            case 0: return Points;
            case 1: return Lines;
            case 2: return LineLoop;
            case 3: return LineStrip;
            case 4: return Triangles;
            case 5: return TriangleStrip;
            case 6: return TriangleFan;
            case 10: return LinesAdjacency;
            case 12: return TrianglesAdjacency;
            case 11: return LineStripAdjacency;
            case 13: return TriangleStripAdjacency;
            case 14: return Patches;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::firstInstanceChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="firstInstance")
    public final Signal1<@io.qt.QtPrimitiveType Integer> firstInstanceChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::firstVertexChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="firstVertex")
    public final Signal1<@io.qt.QtPrimitiveType Integer> firstVertexChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::geometryChanged(Qt3DRender::QGeometry*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="geometry")
    public final Signal1<io.qt.qt3d.render.QGeometry> geometryChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::indexBufferByteOffsetChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="indexBufferByteOffset")
    public final Signal1<@io.qt.QtPrimitiveType Integer> indexBufferByteOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::indexOffsetChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="indexOffset")
    public final Signal1<@io.qt.QtPrimitiveType Integer> indexOffsetChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::instanceCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="instanceCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> instanceCountChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::primitiveRestartEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primitiveRestartEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> primitiveRestartEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::primitiveTypeChanged(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="primitiveType")
    public final Signal1<io.qt.qt3d.render.QGeometryRenderer.PrimitiveType> primitiveTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::restartIndexValueChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="restartIndexValue")
    public final Signal1<@io.qt.QtPrimitiveType Integer> restartIndexValueChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::vertexCountChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexCount")
    public final Signal1<@io.qt.QtPrimitiveType Integer> vertexCountChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::verticesPerPatchChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="verticesPerPatch")
    public final Signal1<@io.qt.QtPrimitiveType Integer> verticesPerPatchChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QGeometryRenderer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QGeometryRenderer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#QGeometryRenderer">Qt3DRender::QGeometryRenderer::QGeometryRenderer(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QGeometryRenderer(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGeometryRenderer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::firstInstance()const</a></p>
     */
    @io.qt.QtPropertyReader(name="firstInstance")
    @io.qt.QtUninvokable
    public final int firstInstance(){
        return firstInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int firstInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::firstVertex()const</a></p>
     */
    @io.qt.QtPropertyReader(name="firstVertex")
    @io.qt.QtUninvokable
    public final int firstVertex(){
        return firstVertex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int firstVertex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::geometry()const</a></p>
     */
    @io.qt.QtPropertyReader(name="geometry")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGeometry geometry(){
        return geometry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QGeometry geometry_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#geometryFactory">Qt3DRender::QGeometryRenderer::geometryFactory()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGeometryFactory geometryFactory(){
        return geometryFactory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QGeometryFactory geometryFactory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::indexBufferByteOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="indexBufferByteOffset")
    @io.qt.QtUninvokable
    public final int indexBufferByteOffset(){
        return indexBufferByteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexBufferByteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::indexOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="indexOffset")
    @io.qt.QtUninvokable
    public final int indexOffset(){
        return indexOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::instanceCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="instanceCount")
    @io.qt.QtUninvokable
    public final int instanceCount(){
        return instanceCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int instanceCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::primitiveRestartEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primitiveRestartEnabled")
    @io.qt.QtUninvokable
    public final boolean primitiveRestartEnabled(){
        return primitiveRestartEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean primitiveRestartEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::primitiveType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="primitiveType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer.PrimitiveType primitiveType(){
        return io.qt.qt3d.render.QGeometryRenderer.PrimitiveType.resolve(primitiveType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int primitiveType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::restartIndexValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="restartIndexValue")
    @io.qt.QtUninvokable
    public final int restartIndexValue(){
        return restartIndexValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int restartIndexValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::setFirstInstance(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="firstInstance")
    public final void setFirstInstance(int firstInstance){
        setFirstInstance_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstInstance);
    }
    
    private native void setFirstInstance_native_int(long __this__nativeId, int firstInstance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::setFirstVertex(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="firstVertex")
    public final void setFirstVertex(int firstVertex){
        setFirstVertex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstVertex);
    }
    
    private native void setFirstVertex_native_int(long __this__nativeId, int firstVertex);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::setGeometry(Qt3DRender::QGeometry*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="geometry")
    public final void setGeometry(io.qt.qt3d.render.QGeometry geometry){
        setGeometry_native_Qt3DRender_QGeometry_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometry));
    }
    
    private native void setGeometry_native_Qt3DRender_QGeometry_ptr(long __this__nativeId, long geometry);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#setGeometryFactory">Qt3DRender::QGeometryRenderer::setGeometryFactory(Qt3DRender::QGeometryFactoryPtr)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setGeometryFactory(io.qt.qt3d.render.QGeometryFactory factory){
        setGeometryFactory_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), factory);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setGeometryFactory_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.render.QGeometryFactory factory);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::setIndexBufferByteOffset(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="indexBufferByteOffset")
    public final void setIndexBufferByteOffset(int offset){
        setIndexBufferByteOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native void setIndexBufferByteOffset_native_int(long __this__nativeId, int offset);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::setIndexOffset(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="indexOffset")
    public final void setIndexOffset(int indexOffset){
        setIndexOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), indexOffset);
    }
    
    private native void setIndexOffset_native_int(long __this__nativeId, int indexOffset);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::setInstanceCount(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="instanceCount")
    public final void setInstanceCount(int instanceCount){
        setInstanceCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
    }
    
    private native void setInstanceCount_native_int(long __this__nativeId, int instanceCount);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::setPrimitiveRestartEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primitiveRestartEnabled")
    public final void setPrimitiveRestartEnabled(boolean enabled){
        setPrimitiveRestartEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setPrimitiveRestartEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::setPrimitiveType(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="primitiveType")
    public final void setPrimitiveType(io.qt.qt3d.render.QGeometryRenderer.PrimitiveType primitiveType){
        setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveType.value());
    }
    
    private native void setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(long __this__nativeId, int primitiveType);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::setRestartIndexValue(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="restartIndexValue")
    public final void setRestartIndexValue(int index){
        setRestartIndexValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setRestartIndexValue_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::setVertexCount(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexCount")
    public final void setVertexCount(int vertexCount){
        setVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), vertexCount);
    }
    
    private native void setVertexCount_native_int(long __this__nativeId, int vertexCount);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::setVerticesPerPatch(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="verticesPerPatch")
    public final void setVerticesPerPatch(int verticesPerPatch){
        setVerticesPerPatch_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), verticesPerPatch);
    }
    
    private native void setVerticesPerPatch_native_int(long __this__nativeId, int verticesPerPatch);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::vertexCount()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexCount")
    @io.qt.QtUninvokable
    public final int vertexCount(){
        return vertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int vertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::verticesPerPatch()const</a></p>
     */
    @io.qt.QtPropertyReader(name="verticesPerPatch")
    @io.qt.QtUninvokable
    public final int verticesPerPatch(){
        return verticesPerPatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int verticesPerPatch_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QGeometryRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QGeometryRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QGeometryRenderer instance, QDeclarativeConstructor constructor);
    
}
