package io.qt.qt3d.render;


/**
 * <p>Qt3DRender::QRayCaster is used to perform ray casting tests in 3d world coordinates</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html">Qt3DRender::QRayCaster</a></p>
 */
public class QRayCaster extends io.qt.qt3d.render.QAbstractRayCaster
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRayCaster.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::directionChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="direction")
    public final Signal1<io.qt.gui.QVector3D> directionChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#length-prop">Qt3DRender::QRayCaster::lengthChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="length")
    public final Signal1<@io.qt.QtPrimitiveType Float> lengthChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::originChanged(QVector3D)</a></p>
     */
    @io.qt.QtPropertyNotify(name="origin")
    public final Signal1<io.qt.gui.QVector3D> originChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRayCaster(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRayCaster() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QRayCaster(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRayCaster instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::direction()const</a></p>
     */
    @io.qt.QtPropertyReader(name="direction")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D direction(){
        return direction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D direction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#length-prop">Qt3DRender::QRayCaster::length()const</a></p>
     */
    @io.qt.QtPropertyReader(name="length")
    @io.qt.QtUninvokable
    public final float length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::origin()const</a></p>
     */
    @io.qt.QtPropertyReader(name="origin")
    @io.qt.QtUninvokable
    public final io.qt.gui.QVector3D origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QVector3D origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::setDirection(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="direction")
    public final void setDirection(io.qt.gui.QVector3D direction){
        setDirection_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(direction));
    }
    
    private native void setDirection_native_cref_QVector3D(long __this__nativeId, long direction);
    
    /**
     * <p>Sets the length of the ray to length</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#setLength">Qt3DRender::QRayCaster::setLength(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="length")
    public final void setLength(float length){
        setLength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), length);
    }
    
    private native void setLength_native_float(long __this__nativeId, float length);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::setOrigin(QVector3D)</a></p>
     */
    @io.qt.QtPropertyWriter(name="origin")
    public final void setOrigin(io.qt.gui.QVector3D origin){
        setOrigin_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    private native void setOrigin_native_cref_QVector3D(long __this__nativeId, long origin);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#trigger">Qt3DRender::QRayCaster::trigger()</a></p>
     */
    public final void trigger(){
        trigger_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void trigger_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qraycaster.html#trigger-1">Qt3DRender::QRayCaster::trigger(QVector3D,QVector3D,float)</a></p>
     */
    public final void trigger(io.qt.gui.QVector3D origin, io.qt.gui.QVector3D direction, float length){
        trigger_native_cref_QVector3D_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin), QtJambi_LibraryUtilities.internal.checkedNativeId(direction), length);
    }
    
    private native void trigger_native_cref_QVector3D_cref_QVector3D_float(long __this__nativeId, long origin, long direction, float length);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRayCaster(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRayCaster(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRayCaster instance, QDeclarativeConstructor constructor);
    
}
