package io.qt.qt3d.render;


/**
 * <p>FrameGraph node to transfer a rectangle of pixel values from one region of a render target to another</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html">Qt3DRender::QBlitFramebuffer</a></p>
 */
public class QBlitFramebuffer extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBlitFramebuffer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#InterpolationMethod-enum">Qt3DRender::QBlitFramebuffer::InterpolationMethod</a></p>
     */
    public enum InterpolationMethod implements io.qt.QtEnumerator {
        Nearest(0),
        Linear(1);

        private InterpolationMethod(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InterpolationMethod resolve(int value) {
            switch (value) {
            case 0: return Nearest;
            case 1: return Linear;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destinationAttachmentPoint-prop">Qt3DRender::QBlitFramebuffer::destinationAttachmentPointChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="destinationAttachmentPoint")
    public final Signal0 destinationAttachmentPointChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destination-prop">Qt3DRender::QBlitFramebuffer::destinationChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="destination")
    public final Signal0 destinationChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destinationRect-prop">Qt3DRender::QBlitFramebuffer::destinationRectChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="destinationRect")
    public final Signal0 destinationRectChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#interpolationMethod-prop">Qt3DRender::QBlitFramebuffer::interpolationMethodChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="interpolationMethod")
    public final Signal0 interpolationMethodChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#sourceAttachmentPoint-prop">Qt3DRender::QBlitFramebuffer::sourceAttachmentPointChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceAttachmentPoint")
    public final Signal0 sourceAttachmentPointChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#source-prop">Qt3DRender::QBlitFramebuffer::sourceChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="source")
    public final Signal0 sourceChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#sourceRect-prop">Qt3DRender::QBlitFramebuffer::sourceRectChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceRect")
    public final Signal0 sourceRectChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QBlitFramebuffer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBlitFramebuffer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#QBlitFramebuffer">Qt3DRender::QBlitFramebuffer::QBlitFramebuffer(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QBlitFramebuffer(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBlitFramebuffer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#createNodeCreationChange">Qt3DCore::QNode::createNodeCreationChange()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange() throws io.qt.QNoImplementationException {
        return createNodeCreationChange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private static io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange_native_constfct(long __this__nativeId) throws io.qt.QNoImplementationException {
        throw new io.qt.QNoImplementationException();
    }
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destination">Qt3DRender::QBlitFramebuffer::destination()const</a></p>
     */
    @io.qt.QtPropertyReader(name="destination")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTarget destination(){
        return destination_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QRenderTarget destination_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destinationAttachmentPoint">Qt3DRender::QBlitFramebuffer::destinationAttachmentPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="destinationAttachmentPoint")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint destinationAttachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(destinationAttachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int destinationAttachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#destinationRect">Qt3DRender::QBlitFramebuffer::destinationRect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="destinationRect")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF destinationRect(){
        return destinationRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF destinationRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#interpolationMethod">Qt3DRender::QBlitFramebuffer::interpolationMethod()const</a></p>
     */
    @io.qt.QtPropertyReader(name="interpolationMethod")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBlitFramebuffer.InterpolationMethod interpolationMethod(){
        return io.qt.qt3d.render.QBlitFramebuffer.InterpolationMethod.resolve(interpolationMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int interpolationMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setDestination">Qt3DRender::QBlitFramebuffer::setDestination(Qt3DRender::QRenderTarget*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="destination")
    @io.qt.QtUninvokable
    public final void setDestination(io.qt.qt3d.render.QRenderTarget destination){
        setDestination_native_Qt3DRender_QRenderTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(destination));
    }
    
    @io.qt.QtUninvokable
    private native void setDestination_native_Qt3DRender_QRenderTarget_ptr(long __this__nativeId, long destination);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setDestinationAttachmentPoint">Qt3DRender::QBlitFramebuffer::setDestinationAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="destinationAttachmentPoint")
    @io.qt.QtUninvokable
    public final void setDestinationAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint destinationAttachmentPoint){
        setDestinationAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), destinationAttachmentPoint.value());
    }
    
    @io.qt.QtUninvokable
    private native void setDestinationAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int destinationAttachmentPoint);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setDestinationRect">Qt3DRender::QBlitFramebuffer::setDestinationRect(QRectF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="destinationRect")
    @io.qt.QtUninvokable
    public final void setDestinationRect(io.qt.core.QRectF destinationRect){
        setDestinationRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(destinationRect));
    }
    
    @io.qt.QtUninvokable
    private native void setDestinationRect_native_cref_QRectF(long __this__nativeId, long destinationRect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setInterpolationMethod">Qt3DRender::QBlitFramebuffer::setInterpolationMethod(Qt3DRender::QBlitFramebuffer::InterpolationMethod)</a></p>
     */
    @io.qt.QtPropertyWriter(name="interpolationMethod")
    @io.qt.QtUninvokable
    public final void setInterpolationMethod(io.qt.qt3d.render.QBlitFramebuffer.InterpolationMethod interpolationMethod){
        setInterpolationMethod_native_Qt3DRender_QBlitFramebuffer_InterpolationMethod(QtJambi_LibraryUtilities.internal.nativeId(this), interpolationMethod.value());
    }
    
    @io.qt.QtUninvokable
    private native void setInterpolationMethod_native_Qt3DRender_QBlitFramebuffer_InterpolationMethod(long __this__nativeId, int interpolationMethod);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setSource">Qt3DRender::QBlitFramebuffer::setSource(Qt3DRender::QRenderTarget*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    @io.qt.QtUninvokable
    public final void setSource(io.qt.qt3d.render.QRenderTarget source){
        setSource_native_Qt3DRender_QRenderTarget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    @io.qt.QtUninvokable
    private native void setSource_native_Qt3DRender_QRenderTarget_ptr(long __this__nativeId, long source);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setSourceAttachmentPoint">Qt3DRender::QBlitFramebuffer::setSourceAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceAttachmentPoint")
    @io.qt.QtUninvokable
    public final void setSourceAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint sourceAttachmentPoint){
        setSourceAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), sourceAttachmentPoint.value());
    }
    
    @io.qt.QtUninvokable
    private native void setSourceAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int sourceAttachmentPoint);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#setSourceRect">Qt3DRender::QBlitFramebuffer::setSourceRect(QRectF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceRect")
    @io.qt.QtUninvokable
    public final void setSourceRect(io.qt.core.QRectF sourceRect){
        setSourceRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect));
    }
    
    @io.qt.QtUninvokable
    private native void setSourceRect_native_cref_QRectF(long __this__nativeId, long sourceRect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#source">Qt3DRender::QBlitFramebuffer::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTarget source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QRenderTarget source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#sourceAttachmentPoint">Qt3DRender::QBlitFramebuffer::sourceAttachmentPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceAttachmentPoint")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint sourceAttachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(sourceAttachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int sourceAttachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblitframebuffer.html#sourceRect">Qt3DRender::QBlitFramebuffer::sourceRect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceRect")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF sourceRect(){
        return sourceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF sourceRect_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBlitFramebuffer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBlitFramebuffer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBlitFramebuffer instance, QDeclarativeConstructor constructor);
    
}
