package io.qt.qt3d.render;


/**
 * <p>Generates a Shader Program content from loaded graphs</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html">Qt3DRender::QShaderProgramBuilder</a></p>
 */
public class QShaderProgramBuilder extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderProgramBuilder.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::computeShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="computeShaderCode")
    public final Signal1<io.qt.core.QByteArray> computeShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::computeShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="computeShaderGraph")
    public final Signal1<io.qt.core.QUrl> computeShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::enabledLayersChanged(QStringList)</a></p>
     */
    @io.qt.QtPropertyNotify(name="enabledLayers")
    public final Signal1<java.util.List<java.lang.String>> enabledLayersChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="fragmentShaderCode")
    public final Signal1<io.qt.core.QByteArray> fragmentShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="fragmentShaderGraph")
    public final Signal1<io.qt.core.QUrl> fragmentShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="geometryShaderCode")
    public final Signal1<io.qt.core.QByteArray> geometryShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="geometryShaderGraph")
    public final Signal1<io.qt.core.QUrl> geometryShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::shaderProgramChanged(Qt3DRender::QShaderProgram*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="shaderProgram")
    public final Signal1<io.qt.qt3d.render.QShaderProgram> shaderProgramChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationControlShaderCode")
    public final Signal1<io.qt.core.QByteArray> tessellationControlShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationControlShaderGraph")
    public final Signal1<io.qt.core.QUrl> tessellationControlShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationEvaluationShaderCode")
    public final Signal1<io.qt.core.QByteArray> tessellationEvaluationShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="tessellationEvaluationShaderGraph")
    public final Signal1<io.qt.core.QUrl> tessellationEvaluationShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderCodeChanged(QByteArray)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexShaderCode")
    public final Signal1<io.qt.core.QByteArray> vertexShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderGraphChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="vertexShaderGraph")
    public final Signal1<io.qt.core.QUrl> vertexShaderGraphChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QShaderProgramBuilder(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderProgramBuilder() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QShaderProgramBuilder(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderProgramBuilder instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::computeShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="computeShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray computeShaderCode(){
        return computeShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray computeShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::computeShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="computeShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl computeShaderGraph(){
        return computeShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl computeShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::enabledLayers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="enabledLayers")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList enabledLayers(){
        return enabledLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList enabledLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="fragmentShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray fragmentShaderCode(){
        return fragmentShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray fragmentShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::fragmentShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="fragmentShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl fragmentShaderGraph(){
        return fragmentShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl fragmentShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="geometryShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray geometryShaderCode(){
        return geometryShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray geometryShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::geometryShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="geometryShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl geometryShaderGraph(){
        return geometryShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl geometryShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setComputeShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="computeShaderGraph")
    public final void setComputeShaderGraph(io.qt.core.QUrl computeShaderGraph){
        setComputeShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(computeShaderGraph));
    }
    
    private native void setComputeShaderGraph_native_cref_QUrl(long __this__nativeId, long computeShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::setEnabledLayers(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="enabledLayers")
    public final void setEnabledLayers(java.util.Collection<java.lang.String> layers){
        setEnabledLayers_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setEnabledLayers_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> layers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setFragmentShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="fragmentShaderGraph")
    public final void setFragmentShaderGraph(io.qt.core.QUrl fragmentShaderGraph){
        setFragmentShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fragmentShaderGraph));
    }
    
    private native void setFragmentShaderGraph_native_cref_QUrl(long __this__nativeId, long fragmentShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setGeometryShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="geometryShaderGraph")
    public final void setGeometryShaderGraph(io.qt.core.QUrl geometryShaderGraph){
        setGeometryShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometryShaderGraph));
    }
    
    private native void setGeometryShaderGraph_native_cref_QUrl(long __this__nativeId, long geometryShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::setShaderProgram(Qt3DRender::QShaderProgram*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="shaderProgram")
    public final void setShaderProgram(io.qt.qt3d.render.QShaderProgram program){
        setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(program));
    }
    
    private native void setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(long __this__nativeId, long program);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setTessellationControlShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="tessellationControlShaderGraph")
    public final void setTessellationControlShaderGraph(io.qt.core.QUrl tessellationControlShaderGraph){
        setTessellationControlShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationControlShaderGraph));
    }
    
    private native void setTessellationControlShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationControlShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setTessellationEvaluationShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="tessellationEvaluationShaderGraph")
    public final void setTessellationEvaluationShaderGraph(io.qt.core.QUrl tessellationEvaluationShaderGraph){
        setTessellationEvaluationShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationEvaluationShaderGraph));
    }
    
    private native void setTessellationEvaluationShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationEvaluationShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::setVertexShaderGraph(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="vertexShaderGraph")
    public final void setVertexShaderGraph(io.qt.core.QUrl vertexShaderGraph){
        setVertexShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vertexShaderGraph));
    }
    
    private native void setVertexShaderGraph_native_cref_QUrl(long __this__nativeId, long vertexShaderGraph);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::shaderProgram()const</a></p>
     */
    @io.qt.QtPropertyReader(name="shaderProgram")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QShaderProgram shaderProgram(){
        return shaderProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QShaderProgram shaderProgram_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationControlShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray tessellationControlShaderCode(){
        return tessellationControlShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray tessellationControlShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationControlShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationControlShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl tessellationControlShaderGraph(){
        return tessellationControlShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl tessellationControlShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationEvaluationShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray tessellationEvaluationShaderCode(){
        return tessellationEvaluationShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray tessellationEvaluationShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::tessellationEvaluationShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="tessellationEvaluationShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl tessellationEvaluationShaderGraph(){
        return tessellationEvaluationShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl tessellationEvaluationShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexShaderCode")
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray vertexShaderCode(){
        return vertexShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray vertexShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::vertexShaderGraph()const</a></p>
     */
    @io.qt.QtPropertyReader(name="vertexShaderGraph")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl vertexShaderGraph(){
        return vertexShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl vertexShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QShaderProgramBuilder(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QShaderProgramBuilder(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QShaderProgramBuilder instance, QDeclarativeConstructor constructor);
    
}
