package io.qt.qt3d.render;


/**
 * <p>Encapsulates blending information: specifies how the incoming values (what's going to be drawn) are going to affect the existing values (what is already drawn)</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html">Qt3DRender::QBlendEquationArguments</a></p>
 */
public class QBlendEquationArguments extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBlendEquationArguments.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#Blending-enum">Qt3DRender::QBlendEquationArguments::Blending</a></p>
     */
    @io.qt.QtRejectedEntries({"Source1Alpha", "Source1Color", "OneMinusSource1Color0"})
    public enum Blending implements io.qt.QtEnumerator {
        Zero(0),
        One(1),
        SourceColor(768),
        SourceAlpha(770),
        Source1Alpha(771),
        Source1Color(772),
        DestinationColor(774),
        DestinationAlpha(772),
        SourceAlphaSaturate(776),
        ConstantColor(32769),
        ConstantAlpha(32771),
        OneMinusSourceColor(769),
        OneMinusSourceAlpha(771),
        OneMinusDestinationAlpha(773),
        OneMinusDestinationColor(775),
        OneMinusConstantColor(32770),
        OneMinusConstantAlpha(32772),
        OneMinusSource1Alpha(32773),
        OneMinusSource1Color(32774),
        OneMinusSource1Color0(32774);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Blending(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Blending resolve(int value) {
            switch (value) {
            case 0: return Zero;
            case 1: return One;
            case 768: return SourceColor;
            case 770: return SourceAlpha;
            case 774: return DestinationColor;
            case 772: return DestinationAlpha;
            case 776: return SourceAlphaSaturate;
            case 32769: return ConstantColor;
            case 32771: return ConstantAlpha;
            case 769: return OneMinusSourceColor;
            case 771: return OneMinusSourceAlpha;
            case 773: return OneMinusDestinationAlpha;
            case 775: return OneMinusDestinationColor;
            case 32770: return OneMinusConstantColor;
            case 32772: return OneMinusConstantAlpha;
            case 32773: return OneMinusSource1Alpha;
            case 32774: return OneMinusSource1Color;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#bufferIndex-prop">Qt3DRender::QBlendEquationArguments::bufferIndexChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="bufferIndex")
    public final Signal1<@io.qt.QtPrimitiveType Integer> bufferIndexChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationAlpha-prop">Qt3DRender::QBlendEquationArguments::destinationAlphaChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyNotify(name="destinationAlpha")
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> destinationAlphaChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationRgb-prop">Qt3DRender::QBlendEquationArguments::destinationRgbChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyNotify(name="destinationRgb")
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> destinationRgbChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationRgbaChanged">Qt3DRender::QBlendEquationArguments::destinationRgbaChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> destinationRgbaChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceAlpha-prop">Qt3DRender::QBlendEquationArguments::sourceAlphaChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceAlpha")
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> sourceAlphaChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceRgb-prop">Qt3DRender::QBlendEquationArguments::sourceRgbChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceRgb")
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> sourceRgbChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceRgbaChanged">Qt3DRender::QBlendEquationArguments::sourceRgbaChanged(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    public final Signal1<io.qt.qt3d.render.QBlendEquationArguments.Blending> sourceRgbaChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBlendEquationArguments(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBlendEquationArguments() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#QBlendEquationArguments">Qt3DRender::QBlendEquationArguments::QBlendEquationArguments(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QBlendEquationArguments(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBlendEquationArguments instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#bufferIndex-prop">Qt3DRender::QBlendEquationArguments::bufferIndex()const</a></p>
     */
    @io.qt.QtPropertyReader(name="bufferIndex")
    @io.qt.QtUninvokable
    public final int bufferIndex(){
        return bufferIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int bufferIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationAlpha-prop">Qt3DRender::QBlendEquationArguments::destinationAlpha()const</a></p>
     */
    @io.qt.QtPropertyReader(name="destinationAlpha")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBlendEquationArguments.Blending destinationAlpha(){
        return io.qt.qt3d.render.QBlendEquationArguments.Blending.resolve(destinationAlpha_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int destinationAlpha_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationRgb-prop">Qt3DRender::QBlendEquationArguments::destinationRgb()const</a></p>
     */
    @io.qt.QtPropertyReader(name="destinationRgb")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBlendEquationArguments.Blending destinationRgb(){
        return io.qt.qt3d.render.QBlendEquationArguments.Blending.resolve(destinationRgb_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int destinationRgb_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#bufferIndex-prop">Qt3DRender::QBlendEquationArguments::setBufferIndex(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="bufferIndex")
    public final void setBufferIndex(int index){
        setBufferIndex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setBufferIndex_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationAlpha-prop">Qt3DRender::QBlendEquationArguments::setDestinationAlpha(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyWriter(name="destinationAlpha")
    public final void setDestinationAlpha(io.qt.qt3d.render.QBlendEquationArguments.Blending destinationAlpha){
        setDestinationAlpha_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), destinationAlpha.value());
    }
    
    private native void setDestinationAlpha_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int destinationAlpha);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#destinationRgb-prop">Qt3DRender::QBlendEquationArguments::setDestinationRgb(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyWriter(name="destinationRgb")
    public final void setDestinationRgb(io.qt.qt3d.render.QBlendEquationArguments.Blending destinationRgb){
        setDestinationRgb_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), destinationRgb.value());
    }
    
    private native void setDestinationRgb_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int destinationRgb);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#setDestinationRgba">Qt3DRender::QBlendEquationArguments::setDestinationRgba(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    public final void setDestinationRgba(io.qt.qt3d.render.QBlendEquationArguments.Blending destinationRgba){
        setDestinationRgba_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), destinationRgba.value());
    }
    
    private native void setDestinationRgba_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int destinationRgba);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceAlpha-prop">Qt3DRender::QBlendEquationArguments::setSourceAlpha(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceAlpha")
    public final void setSourceAlpha(io.qt.qt3d.render.QBlendEquationArguments.Blending sourceAlpha){
        setSourceAlpha_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), sourceAlpha.value());
    }
    
    private native void setSourceAlpha_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int sourceAlpha);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceRgb-prop">Qt3DRender::QBlendEquationArguments::setSourceRgb(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceRgb")
    public final void setSourceRgb(io.qt.qt3d.render.QBlendEquationArguments.Blending sourceRgb){
        setSourceRgb_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), sourceRgb.value());
    }
    
    private native void setSourceRgb_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int sourceRgb);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#setSourceRgba">Qt3DRender::QBlendEquationArguments::setSourceRgba(Qt3DRender::QBlendEquationArguments::Blending)</a></p>
     */
    public final void setSourceRgba(io.qt.qt3d.render.QBlendEquationArguments.Blending sourceRgba){
        setSourceRgba_native_Qt3DRender_QBlendEquationArguments_Blending(QtJambi_LibraryUtilities.internal.nativeId(this), sourceRgba.value());
    }
    
    private native void setSourceRgba_native_Qt3DRender_QBlendEquationArguments_Blending(long __this__nativeId, int sourceRgba);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceAlpha-prop">Qt3DRender::QBlendEquationArguments::sourceAlpha()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceAlpha")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBlendEquationArguments.Blending sourceAlpha(){
        return io.qt.qt3d.render.QBlendEquationArguments.Blending.resolve(sourceAlpha_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int sourceAlpha_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qblendequationarguments.html#sourceRgb-prop">Qt3DRender::QBlendEquationArguments::sourceRgb()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceRgb")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBlendEquationArguments.Blending sourceRgb(){
        return io.qt.qt3d.render.QBlendEquationArguments.Blending.resolve(sourceRgb_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int sourceRgb_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBlendEquationArguments(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBlendEquationArguments(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBlendEquationArguments instance, QDeclarativeConstructor constructor);
    
}
