package io.qt.qt3d.render;


/**
 * <p>An abstract base class for ray casting in 3d scenes</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html">Qt3DRender::QAbstractRayCaster</a></p>
 */
public class QAbstractRayCaster extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractRayCaster.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::QAbstractRayCaster::FilterMode</a></p>
     */
    public enum FilterMode implements io.qt.QtEnumerator {
        AcceptAnyMatchingLayers(0),
        AcceptAllMatchingLayers(1),
        DiscardAnyMatchingLayers(2),
        DiscardAllMatchingLayers(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FilterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FilterMode resolve(int value) {
            switch (value) {
            case 0: return AcceptAnyMatchingLayers;
            case 1: return AcceptAllMatchingLayers;
            case 2: return DiscardAnyMatchingLayers;
            case 3: return DiscardAllMatchingLayers;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#RunMode-enum">Qt3DRender::QAbstractRayCaster::RunMode</a></p>
     */
    public enum RunMode implements io.qt.QtEnumerator {
        Continuous(0),
        SingleShot(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RunMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RunMode resolve(int value) {
            switch (value) {
            case 0: return Continuous;
            case 1: return SingleShot;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    



    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::filterModeChanged(Qt3DRender::QAbstractRayCaster::FilterMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="filterMode")
    public final Signal1<io.qt.qt3d.render.QAbstractRayCaster.FilterMode> filterModeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#hits-prop">Qt3DRender::QAbstractRayCaster::hitsChanged(Qt3DRender::QAbstractRayCaster::Hits)</a></p>
     */
    @io.qt.QtPropertyNotify(name="hits")
    public final Signal1<io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit>> hitsChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::runModeChanged(Qt3DRender::QAbstractRayCaster::RunMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="runMode")
    public final Signal1<io.qt.qt3d.render.QAbstractRayCaster.RunMode> runModeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractRayCaster(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractRayCaster() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QAbstractRayCaster(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractRayCaster instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#addLayer">Qt3DRender::QAbstractRayCaster::addLayer(Qt3DRender::QLayer*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void addLayer(io.qt.qt3d.render.QLayer layer){
        addLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @io.qt.QtUninvokable
    private native void addLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::filterMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="filterMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.FilterMode filterMode(){
        return io.qt.qt3d.render.QAbstractRayCaster.FilterMode.resolve(filterMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int filterMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#hits-prop">Qt3DRender::QAbstractRayCaster::hits()const</a></p>
     */
    @io.qt.QtPropertyReader(name="hits")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit> hits(){
        return hits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit> hits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#layers">Qt3DRender::QAbstractRayCaster::layers()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.qt3d.render.QLayer> layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.render.QLayer> layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#removeLayer">Qt3DRender::QAbstractRayCaster::removeLayer(Qt3DRender::QLayer*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeLayer(io.qt.qt3d.render.QLayer layer){
        removeLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @io.qt.QtUninvokable
    private native void removeLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::runMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="runMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.RunMode runMode(){
        return io.qt.qt3d.render.QAbstractRayCaster.RunMode.resolve(runMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int runMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::setFilterMode(Qt3DRender::QAbstractRayCaster::FilterMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="filterMode")
    public final void setFilterMode(io.qt.qt3d.render.QAbstractRayCaster.FilterMode filterMode){
        setFilterMode_native_Qt3DRender_QAbstractRayCaster_FilterMode(QtJambi_LibraryUtilities.internal.nativeId(this), filterMode.value());
    }
    
    private native void setFilterMode_native_Qt3DRender_QAbstractRayCaster_FilterMode(long __this__nativeId, int filterMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::setRunMode(Qt3DRender::QAbstractRayCaster::RunMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="runMode")
    public final void setRunMode(io.qt.qt3d.render.QAbstractRayCaster.RunMode runMode){
        setRunMode_native_Qt3DRender_QAbstractRayCaster_RunMode(QtJambi_LibraryUtilities.internal.nativeId(this), runMode.value());
    }
    
    private native void setRunMode_native_Qt3DRender_QAbstractRayCaster_RunMode(long __this__nativeId, int runMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#createNodeCreationChange">Qt3DCore::QNode::createNodeCreationChange()const</a></p>
     */
    @io.qt.QtUninvokable
    protected io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange(){
        return createNodeCreationChange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractRayCaster(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QAbstractRayCaster(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QAbstractRayCaster instance, QDeclarativeConstructor constructor);
    
}
