package io.qt.qt3d.render;


/**
 * <p>Sets the actions to be taken when stencil and depth tests fail</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html">Qt3DRender::QStencilOperationArguments</a></p>
 */
public final class QStencilOperationArguments extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QStencilOperationArguments.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#FaceMode-enum">Qt3DRender::QStencilOperationArguments::FaceMode</a></p>
     */
    public enum FaceMode implements io.qt.QtEnumerator {
        Front(1028),
        Back(1029),
        FrontAndBack(1032);

        private FaceMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FaceMode resolve(int value) {
            switch (value) {
            case 1028: return Front;
            case 1029: return Back;
            case 1032: return FrontAndBack;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#Operation-enum">Qt3DRender::QStencilOperationArguments::Operation</a></p>
     */
    public enum Operation implements io.qt.QtEnumerator {
        Zero(0),
        Keep(7680),
        Replace(7681),
        Increment(7682),
        Decrement(7683),
        IncrementWrap(34055),
        DecrementWrap(34056),
        Invert(5386);

        private Operation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Operation resolve(int value) {
            switch (value) {
            case 0: return Zero;
            case 7680: return Keep;
            case 7681: return Replace;
            case 7682: return Increment;
            case 7683: return Decrement;
            case 34055: return IncrementWrap;
            case 34056: return DecrementWrap;
            case 5386: return Invert;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::allTestsPassOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyNotify(name="allTestsPassOperation")
    public final Signal1<io.qt.qt3d.render.QStencilOperationArguments.Operation> allTestsPassOperationChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::depthTestFailureOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyNotify(name="depthTestFailureOperation")
    public final Signal1<io.qt.qt3d.render.QStencilOperationArguments.Operation> depthTestFailureOperationChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#faceMode-prop">Qt3DRender::QStencilOperationArguments::faceModeChanged(Qt3DRender::QStencilOperationArguments::FaceMode)</a></p>
     */
    @io.qt.QtPropertyNotify(name="faceMode")
    public final Signal1<io.qt.qt3d.render.QStencilOperationArguments.FaceMode> faceModeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::stencilTestFailureOperationChanged(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyNotify(name="stencilTestFailureOperation")
    public final Signal1<io.qt.qt3d.render.QStencilOperationArguments.Operation> stencilTestFailureOperationChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::allTestsPassOperation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="allTestsPassOperation")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.Operation allTestsPassOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(allTestsPassOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int allTestsPassOperation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::depthTestFailureOperation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="depthTestFailureOperation")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.Operation depthTestFailureOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(depthTestFailureOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int depthTestFailureOperation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#faceMode-prop">Qt3DRender::QStencilOperationArguments::faceMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="faceMode")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.FaceMode faceMode(){
        return io.qt.qt3d.render.QStencilOperationArguments.FaceMode.resolve(faceMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int faceMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#allTestsPassOperation-prop">Qt3DRender::QStencilOperationArguments::setAllTestsPassOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyWriter(name="allTestsPassOperation")
    public final void setAllTestsPassOperation(io.qt.qt3d.render.QStencilOperationArguments.Operation operation){
        setAllTestsPassOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setAllTestsPassOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#depthTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::setDepthTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyWriter(name="depthTestFailureOperation")
    public final void setDepthTestFailureOperation(io.qt.qt3d.render.QStencilOperationArguments.Operation operation){
        setDepthTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setDepthTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::setStencilTestFailureOperation(Qt3DRender::QStencilOperationArguments::Operation)</a></p>
     */
    @io.qt.QtPropertyWriter(name="stencilTestFailureOperation")
    public final void setStencilTestFailureOperation(io.qt.qt3d.render.QStencilOperationArguments.Operation operation){
        setStencilTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(QtJambi_LibraryUtilities.internal.nativeId(this), operation.value());
    }
    
    private native void setStencilTestFailureOperation_native_Qt3DRender_QStencilOperationArguments_Operation(long __this__nativeId, int operation);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qstenciloperationarguments.html#stencilTestFailureOperation-prop">Qt3DRender::QStencilOperationArguments::stencilTestFailureOperation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="stencilTestFailureOperation")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QStencilOperationArguments.Operation stencilTestFailureOperation(){
        return io.qt.qt3d.render.QStencilOperationArguments.Operation.resolve(stencilTestFailureOperation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int stencilTestFailureOperation_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QStencilOperationArguments(QPrivateConstructor p) { super(p); } 
    
}
