package io.qt.qt3d.render;


/**
 * <p>Provides Image access to shader programs</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html">Qt3DRender::QShaderImage</a></p>
 */
public class QShaderImage extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderImage.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::Access</a></p>
     */
    public enum Access implements io.qt.QtEnumerator {
        ReadOnly(0),
        WriteOnly(1),
        ReadWrite(2);

        private Access(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Access resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return WriteOnly;
            case 2: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::ImageFormat</a></p>
     */
    public enum ImageFormat implements io.qt.QtEnumerator {
        NoFormat(0),
        Automatic(1),
        R8_UNorm(33321),
        RG8_UNorm(33323),
        RGBA8_UNorm(32856),
        R16_UNorm(33322),
        RG16_UNorm(33324),
        RGBA16_UNorm(32859),
        R8_SNorm(36756),
        RG8_SNorm(36757),
        RGBA8_SNorm(36759),
        R16_SNorm(36760),
        RG16_SNorm(36761),
        RGBA16_SNorm(36763),
        R8U(33330),
        RG8U(33336),
        RGBA8U(36220),
        R16U(33332),
        RG16U(33338),
        RGBA16U(36214),
        R32U(33334),
        RG32U(33340),
        RGBA32U(36208),
        R8I(33329),
        RG8I(33335),
        RGBA8I(36238),
        R16I(33331),
        RG16I(33337),
        RGBA16I(36232),
        R32I(33333),
        RG32I(33339),
        RGBA32I(36226),
        R16F(33325),
        RG16F(33327),
        RGBA16F(34842),
        R32F(33326),
        RG32F(33328),
        RGBA32F(34836),
        RG11B10F(35898),
        RGB10A2(32857),
        RGB10A2U(36975);

        private ImageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ImageFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34836: return RGBA32F;
            case 35898: return RG11B10F;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::accessChanged(Qt3DRender::QShaderImage::Access)</a></p>
     */
    @io.qt.QtPropertyNotify(name="access")
    public final Signal1<io.qt.qt3d.render.QShaderImage.Access> accessChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::formatChanged(Qt3DRender::QShaderImage::ImageFormat)</a></p>
     */
    @io.qt.QtPropertyNotify(name="format")
    public final Signal1<io.qt.qt3d.render.QShaderImage.ImageFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::layerChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="layer")
    public final Signal1<@io.qt.QtPrimitiveType Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::layeredChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="layered")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> layeredChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::mipLevelChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mipLevel")
    public final Signal1<@io.qt.QtPrimitiveType Integer> mipLevelChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::textureChanged(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="texture")
    public final Signal1<io.qt.qt3d.render.QAbstractTexture> textureChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QShaderImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QShaderImage(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::access()const</a></p>
     */
    @io.qt.QtPropertyReader(name="access")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.Access access(){
        return io.qt.qt3d.render.QShaderImage.Access.resolve(access_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int access_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::format()const</a></p>
     */
    @io.qt.QtPropertyReader(name="format")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.ImageFormat format(){
        return io.qt.qt3d.render.QShaderImage.ImageFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::layer()const</a></p>
     */
    @io.qt.QtPropertyReader(name="layer")
    @io.qt.QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::layered()const</a></p>
     */
    @io.qt.QtPropertyReader(name="layered")
    @io.qt.QtUninvokable
    public final boolean layered(){
        return layered_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean layered_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::mipLevel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mipLevel")
    @io.qt.QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::setAccess(Qt3DRender::QShaderImage::Access)</a></p>
     */
    @io.qt.QtPropertyWriter(name="access")
    public final void setAccess(io.qt.qt3d.render.QShaderImage.Access access){
        setAccess_native_Qt3DRender_QShaderImage_Access(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccess_native_Qt3DRender_QShaderImage_Access(long __this__nativeId, int access);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::setFormat(Qt3DRender::QShaderImage::ImageFormat)</a></p>
     */
    @io.qt.QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QShaderImage.ImageFormat format){
        setFormat_native_Qt3DRender_QShaderImage_ImageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QShaderImage_ImageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::setLayer(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::setLayered(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="layered")
    public final void setLayered(boolean layered){
        setLayered_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), layered);
    }
    
    private native void setLayered_native_bool(long __this__nativeId, boolean layered);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::setMipLevel(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int mipLevel){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int mipLevel);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::setTexture(Qt3DRender::QAbstractTexture*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="texture")
    public final void setTexture(io.qt.qt3d.render.QAbstractTexture texture){
        setTexture_native_Qt3DRender_QAbstractTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    private native void setTexture_native_Qt3DRender_QAbstractTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::texture()const</a></p>
     */
    @io.qt.QtPropertyReader(name="texture")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QAbstractTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QShaderImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QShaderImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QShaderImage instance, QDeclarativeConstructor constructor);
    
}
