package io.qt.qt3d.render;


/**
 * <p>Class to emplace a memory barrier</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qmemorybarrier.html">Qt3DRender::QMemoryBarrier</a></p>
 */
public class QMemoryBarrier extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMemoryBarrier.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::Operation</a></p>
     * 
     * @see Operations
     */
    public enum Operation implements io.qt.QtFlagEnumerator {
        None(0),
        VertexAttributeArray(1),
        ElementArray(2),
        Uniform(4),
        TextureFetch(8),
        ShaderImageAccess(16),
        Command(32),
        PixelBuffer(64),
        TextureUpdate(128),
        BufferUpdate(256),
        FrameBuffer(512),
        TransformFeedback(1024),
        AtomicCounter(2048),
        ShaderStorage(4096),
        QueryBuffer(8192),
        All(-1);

        private Operation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Operations asFlags() {
            return new Operations(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Operations combined(Operation e) {
            return new Operations(this, e);
        }

        /**
         * Creates a new {@link Operations} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Operations flags(Operation ... values) {
            return new Operations(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Operation resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return VertexAttributeArray;
            case 2: return ElementArray;
            case 4: return Uniform;
            case 8: return TextureFetch;
            case 16: return ShaderImageAccess;
            case 32: return Command;
            case 64: return PixelBuffer;
            case 128: return TextureUpdate;
            case 256: return BufferUpdate;
            case 512: return FrameBuffer;
            case 1024: return TransformFeedback;
            case 2048: return AtomicCounter;
            case 4096: return ShaderStorage;
            case 8192: return QueryBuffer;
            case -1: return All;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Operation}
     */
    public static final class Operations extends io.qt.QFlags<Operation> implements Comparable<Operations> {
        private static final long serialVersionUID = 0xf54c38a476f13420L;

        /**
         * Creates a new Operations where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Operations(Operation ... args){
            super(args);
        }

        /**
         * Creates a new Operations with given <code>value</code>.
         * @param value
         */
        public Operations(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Operations
         */
        @Override
        public final Operations combined(Operation e){
            return new Operations(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Operations setFlag(Operation e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Operations setFlag(Operation e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Operations.
         * @return array of enum entries
         */
        @Override
        public final Operation[] flags(){
            return super.flags(Operation.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Operations clone(){
            return new Operations(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Operations other){
            return Integer.compare(value(), other.value());
        }
    }
    

    public final Signal1<io.qt.qt3d.render.QMemoryBarrier.Operations> waitOperationsChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QMemoryBarrier(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMemoryBarrier() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    @SuppressWarnings({"exports"})
    public QMemoryBarrier(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMemoryBarrier instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#createNodeCreationChange">Qt3DCore::QNode::createNodeCreationChange()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange() throws io.qt.QNoImplementationException {
        return createNodeCreationChange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private static io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange_native_constfct(long __this__nativeId) throws io.qt.QNoImplementationException {
        throw new io.qt.QNoImplementationException();
    }
    /**
     * <p>Overloaded function for {@link #setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.Operations)}.</p>
     */
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.Operation ... operations){
        setWaitOperations(new io.qt.qt3d.render.QMemoryBarrier.Operations(operations));
    }
    
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.Operations operations){
        setWaitOperations_native_QFlags_Qt3DRender_QMemoryBarrier_Operation_(QtJambi_LibraryUtilities.internal.nativeId(this), operations.value());
    }
    
    private native void setWaitOperations_native_QFlags_Qt3DRender_QMemoryBarrier_Operation_(long __this__nativeId, int operations);
    
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QMemoryBarrier.Operations waitOperations(){
        return new io.qt.qt3d.render.QMemoryBarrier.Operations(waitOperations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int waitOperations_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QMemoryBarrier(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QMemoryBarrier(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QMemoryBarrier instance, QDeclarativeConstructor constructor);
    
}
