package io.qt.qt3d.render;


/**
 * <p>Class to clear buffers</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html">Qt3DRender::QClearBuffers</a></p>
 */
public class QClearBuffers extends io.qt.qt3d.render.QFrameGraphNode
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcColorBuffer = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QClearBuffers.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::QClearBuffers::BufferType</a></p>
     */
    public enum BufferType implements io.qt.QtEnumerator {
        None(0),
        ColorBuffer(1),
        DepthBuffer(2),
        StencilBuffer(4),
        DepthStencilBuffer(6),
        ColorDepthBuffer(3),
        ColorDepthStencilBuffer(7),
        AllBuffers(-1);

        private BufferType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static BufferType resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return ColorBuffer;
            case 2: return DepthBuffer;
            case 4: return StencilBuffer;
            case 6: return DepthStencilBuffer;
            case 3: return ColorDepthBuffer;
            case 7: return ColorDepthStencilBuffer;
            case -1: return AllBuffers;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::buffersChanged(Qt3DRender::QClearBuffers::BufferType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="buffers")
    public final Signal1<io.qt.qt3d.render.QClearBuffers.BufferType> buffersChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::clearColorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clearColor")
    public final Signal1<io.qt.gui.QColor> clearColorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::clearDepthValueChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clearDepthValue")
    public final Signal1<@io.qt.QtPrimitiveType Float> clearDepthValueChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::clearStencilValueChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clearStencilValue")
    public final Signal1<@io.qt.QtPrimitiveType Integer> clearStencilValueChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::colorBufferChanged(Qt3DRender::QRenderTargetOutput*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="colorBuffer")
    public final Signal1<io.qt.qt3d.render.QRenderTargetOutput> colorBufferChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QClearBuffers(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QClearBuffers() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#QClearBuffers">Qt3DRender::QClearBuffers::QClearBuffers(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QClearBuffers(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QClearBuffers instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::buffers()const</a></p>
     */
    @io.qt.QtPropertyReader(name="buffers")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QClearBuffers.BufferType buffers(){
        return io.qt.qt3d.render.QClearBuffers.BufferType.resolve(buffers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int buffers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::clearColor()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clearColor")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor clearColor(){
        return clearColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor clearColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::clearDepthValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clearDepthValue")
    @io.qt.QtUninvokable
    public final float clearDepthValue(){
        return clearDepthValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float clearDepthValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::clearStencilValue()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clearStencilValue")
    @io.qt.QtUninvokable
    public final int clearStencilValue(){
        return clearStencilValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int clearStencilValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::colorBuffer()const</a></p>
     */
    @io.qt.QtPropertyReader(name="colorBuffer")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput colorBuffer(){
        return colorBuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QRenderTargetOutput colorBuffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#createNodeCreationChange">Qt3DCore::QNode::createNodeCreationChange()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    protected final io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange() throws io.qt.QNoImplementationException {
        return createNodeCreationChange_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    private static io.qt.qt3d.core.QNodeCreatedChange createNodeCreationChange_native_constfct(long __this__nativeId) throws io.qt.QNoImplementationException {
        throw new io.qt.QNoImplementationException();
    }
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::setBuffers(Qt3DRender::QClearBuffers::BufferType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="buffers")
    public final void setBuffers(io.qt.qt3d.render.QClearBuffers.BufferType buffers){
        setBuffers_native_Qt3DRender_QClearBuffers_BufferType(QtJambi_LibraryUtilities.internal.nativeId(this), buffers.value());
    }
    
    private native void setBuffers_native_Qt3DRender_QClearBuffers_BufferType(long __this__nativeId, int buffers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::setClearColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clearColor")
    public final void setClearColor(io.qt.gui.QColor color){
        setClearColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    private native void setClearColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::setClearDepthValue(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clearDepthValue")
    public final void setClearDepthValue(float clearDepthValue){
        setClearDepthValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), clearDepthValue);
    }
    
    private native void setClearDepthValue_native_float(long __this__nativeId, float clearDepthValue);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::setClearStencilValue(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clearStencilValue")
    public final void setClearStencilValue(int clearStencilValue){
        setClearStencilValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), clearStencilValue);
    }
    
    private native void setClearStencilValue_native_int(long __this__nativeId, int clearStencilValue);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::setColorBuffer(Qt3DRender::QRenderTargetOutput*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="colorBuffer")
    public final void setColorBuffer(io.qt.qt3d.render.QRenderTargetOutput buffer){
        setColorBuffer_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(buffer));
        __rcColorBuffer = buffer;
    }
    
    private native void setColorBuffer_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long buffer);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QClearBuffers(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QClearBuffers(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QClearBuffers instance, QDeclarativeConstructor constructor);
    
}
