package io.qt.qt3d.render;


/**
 * <p>Provides a data store for raw data to later be used as vertices or uniforms</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html">Qt3DRender::QBuffer</a></p>
 */
public class QBuffer extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QBuffer.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#AccessType-enum">Qt3DRender::QBuffer::AccessType</a></p>
     */
    public enum AccessType implements io.qt.QtEnumerator {
        Write(1),
        Read(2),
        ReadWrite(3);

        private AccessType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccessType resolve(int value) {
            switch (value) {
            case 1: return Write;
            case 2: return Read;
            case 3: return ReadWrite;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer-obsolete.html#BufferType-enum">Qt3DRender::QBuffer::BufferType</a></p>
     */
    public enum BufferType implements io.qt.QtEnumerator {
        VertexBuffer(34962),
        IndexBuffer(34963),
        PixelPackBuffer(35051),
        PixelUnpackBuffer(35052),
        UniformBuffer(35345),
        ShaderStorageBuffer(37074),
        DrawIndirectBuffer(36671);

        private BufferType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static BufferType resolve(int value) {
            switch (value) {
            case 34962: return VertexBuffer;
            case 34963: return IndexBuffer;
            case 35051: return PixelPackBuffer;
            case 35052: return PixelUnpackBuffer;
            case 35345: return UniformBuffer;
            case 37074: return ShaderStorageBuffer;
            case 36671: return DrawIndirectBuffer;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#UsageType-enum">Qt3DRender::QBuffer::UsageType</a></p>
     */
    public enum UsageType implements io.qt.QtEnumerator {
        StreamDraw(35040),
        StreamRead(35041),
        StreamCopy(35042),
        StaticDraw(35044),
        StaticRead(35045),
        StaticCopy(35046),
        DynamicDraw(35048),
        DynamicRead(35049),
        DynamicCopy(35050);

        private UsageType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UsageType resolve(int value) {
            switch (value) {
            case 35040: return StreamDraw;
            case 35041: return StreamRead;
            case 35042: return StreamCopy;
            case 35044: return StaticDraw;
            case 35045: return StaticRead;
            case 35046: return StaticCopy;
            case 35048: return DynamicDraw;
            case 35049: return DynamicRead;
            case 35050: return DynamicCopy;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#accessType-prop">Qt3DRender::QBuffer::accessTypeChanged(Qt3DRender::QBuffer::AccessType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="accessType")
    public final Signal1<io.qt.qt3d.render.QBuffer.AccessType> accessTypeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#dataAvailable">Qt3DRender::QBuffer::dataAvailable()</a></p>
     */
    public final Signal0 dataAvailable = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#dataChanged">Qt3DRender::QBuffer::dataChanged(QByteArray)</a></p>
     */
    public final Signal1<io.qt.core.QByteArray> dataChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#syncData-prop">Qt3DRender::QBuffer::syncDataChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="syncData")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> syncDataChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer-obsolete.html#type-prop">Qt3DRender::QBuffer::typeChanged(Qt3DRender::QBuffer::BufferType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="type")
    public final Signal1<io.qt.qt3d.render.QBuffer.BufferType> typeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#usage-prop">Qt3DRender::QBuffer::usageChanged(Qt3DRender::QBuffer::UsageType)</a></p>
     */
    @io.qt.QtPropertyNotify(name="usage")
    public final Signal1<io.qt.qt3d.render.QBuffer.UsageType> usageChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QBuffer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QBuffer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#QBuffer">Qt3DRender::QBuffer::QBuffer(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QBuffer(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QBuffer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>Overloaded constructor for {@link #QBuffer(io.qt.qt3d.render.QBuffer.BufferType, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    @Deprecated
    public QBuffer(io.qt.qt3d.render.QBuffer.BufferType ty) {
        this(ty, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer-obsolete.html#QBuffer-1">Qt3DRender::QBuffer::QBuffer(Qt3DRender::QBuffer::BufferType,Qt3DCore::QNode*)</a></p>
     */
    @Deprecated
    @SuppressWarnings({"exports"})
    public QBuffer(io.qt.qt3d.render.QBuffer.BufferType ty, io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, ty, parent);
    }
    
    @Deprecated
    private native static void initialize_native(QBuffer instance, io.qt.qt3d.render.QBuffer.BufferType ty, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#accessType-prop">Qt3DRender::QBuffer::accessType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accessType")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBuffer.AccessType accessType(){
        return io.qt.qt3d.render.QBuffer.AccessType.resolve(accessType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int accessType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#data">Qt3DRender::QBuffer::data()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray data(){
        return data_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray data_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#dataGenerator">Qt3DRender::QBuffer::dataGenerator()const</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBufferDataGenerator dataGenerator(){
        return dataGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QBufferDataGenerator dataGenerator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#syncData-prop">Qt3DRender::QBuffer::isSyncData()const</a></p>
     */
    @io.qt.QtPropertyReader(name="syncData")
    @io.qt.QtUninvokable
    public final boolean isSyncData(){
        return isSyncData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSyncData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#accessType-prop">Qt3DRender::QBuffer::setAccessType(Qt3DRender::QBuffer::AccessType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="accessType")
    public final void setAccessType(io.qt.qt3d.render.QBuffer.AccessType access){
        setAccessType_native_Qt3DRender_QBuffer_AccessType(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccessType_native_Qt3DRender_QBuffer_AccessType(long __this__nativeId, int access);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#setData">Qt3DRender::QBuffer::setData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setData(io.qt.core.QByteArray bytes){
        setData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    @io.qt.QtUninvokable
    private native void setData_native_cref_QByteArray(long __this__nativeId, long bytes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#setDataGenerator">Qt3DRender::QBuffer::setDataGenerator(Qt3DRender::QBufferDataGeneratorPtr)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setDataGenerator(io.qt.qt3d.render.QBufferDataGenerator functor){
        setDataGenerator_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), functor);
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setDataGenerator_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.render.QBufferDataGenerator functor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#syncData-prop">Qt3DRender::QBuffer::setSyncData(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="syncData")
    public final void setSyncData(boolean syncData){
        setSyncData_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), syncData);
    }
    
    private native void setSyncData_native_bool(long __this__nativeId, boolean syncData);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer-obsolete.html#type-prop">Qt3DRender::QBuffer::setType(Qt3DRender::QBuffer::BufferType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="type")
    @Deprecated
    public final void setType(io.qt.qt3d.render.QBuffer.BufferType type){
        setType_native_Qt3DRender_QBuffer_BufferType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @Deprecated
    private native void setType_native_Qt3DRender_QBuffer_BufferType(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#usage-prop">Qt3DRender::QBuffer::setUsage(Qt3DRender::QBuffer::UsageType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="usage")
    public final void setUsage(io.qt.qt3d.render.QBuffer.UsageType usage){
        setUsage_native_Qt3DRender_QBuffer_UsageType(QtJambi_LibraryUtilities.internal.nativeId(this), usage.value());
    }
    
    private native void setUsage_native_Qt3DRender_QBuffer_UsageType(long __this__nativeId, int usage);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer-obsolete.html#type-prop">Qt3DRender::QBuffer::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBuffer.BufferType type(){
        return io.qt.qt3d.render.QBuffer.BufferType.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#updateData">Qt3DRender::QBuffer::updateData(int,QByteArray)</a></p>
     */
    public final void updateData(int offset, io.qt.core.QByteArray bytes){
        updateData_native_int_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), offset, QtJambi_LibraryUtilities.internal.checkedNativeId(bytes));
    }
    
    private native void updateData_native_int_cref_QByteArray(long __this__nativeId, int offset, long bytes);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qbuffer.html#usage-prop">Qt3DRender::QBuffer::usage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="usage")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QBuffer.UsageType usage(){
        return io.qt.qt3d.render.QBuffer.UsageType.resolve(usage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int usage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3dcore-qnode-obsolete.html#sceneChangeEvent">Qt3DCore::QNode::sceneChangeEvent(Qt3DCore::QSceneChangePtr)</a></p>
     */
    @io.qt.QtUninvokable
    protected void sceneChangeEvent(io.qt.qt3d.core.QSceneChange change){
        sceneChangeEvent_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), change);
    }
    
    @io.qt.QtUninvokable
    private native void sceneChangeEvent_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.core.QSceneChange change);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QBuffer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QBuffer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QBuffer instance, QDeclarativeConstructor constructor);
    
}
