package io.qt.qt3d.render;


/**
 * <p>Encapsulate a QAbstractLight object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html">Qt3DRender::QAbstractLight</a></p>
 */
public class QAbstractLight extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractLight.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#Type-enum">Qt3DRender::QAbstractLight::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        PointLight(0),
        DirectionalLight(1),
        SpotLight(2);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return PointLight;
            case 1: return DirectionalLight;
            case 2: return SpotLight;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::colorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="color")
    public final Signal1<io.qt.gui.QColor> colorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::intensityChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="intensity")
    public final Signal1<@io.qt.QtPrimitiveType Float> intensityChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::color()const</a></p>
     */
    @io.qt.QtPropertyReader(name="color")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor color(){
        return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::intensity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="intensity")
    @io.qt.QtUninvokable
    public final float intensity(){
        return intensity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float intensity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#color-prop">Qt3DRender::QAbstractLight::setColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="color")
    public final void setColor(io.qt.gui.QColor color){
        setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#intensity-prop">Qt3DRender::QAbstractLight::setIntensity(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="intensity")
    public final void setIntensity(float intensity){
        setIntensity_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), intensity);
    }
    
    private native void setIntensity_native_float(long __this__nativeId, float intensity);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qt3drender-qabstractlight.html#type">Qt3DRender::QAbstractLight::type()const</a></p>
     */
    @io.qt.QtPropertyReader(name="type")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QAbstractLight.Type type(){
        return io.qt.qt3d.render.QAbstractLight.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QAbstractLight(QPrivateConstructor p) { super(p); } 
    
}
