package io.qt.qt3d.render;


/**
 * <p>Provides a way of specifying the render surface</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html">Qt3DRender::QRenderSurfaceSelector</a></p>
 */
public class QRenderSurfaceSelector extends io.qt.qt3d.render.QFrameGraphNode
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcSurfaceObject = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderSurfaceSelector.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#externalRenderTargetSize-prop">Qt3DRender::QRenderSurfaceSelector::externalRenderTargetSizeChanged(QSize)</a></p>
     */
    @io.qt.QtPropertyNotify(name="externalRenderTargetSize")
    public final Signal1<io.qt.core.QSize> externalRenderTargetSizeChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surface-prop">Qt3DRender::QRenderSurfaceSelector::surfaceChanged(QObject*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="surface")
    public final Signal1<io.qt.core.QObject> surfaceChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::surfacePixelRatioChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="surfacePixelRatio")
    public final Signal1<@io.qt.QtPrimitiveType Float> surfacePixelRatioChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QRenderSurfaceSelector(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderSurfaceSelector() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#QRenderSurfaceSelector">Qt3DRender::QRenderSurfaceSelector::QRenderSurfaceSelector(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderSurfaceSelector(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderSurfaceSelector instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#externalRenderTargetSize-prop">Qt3DRender::QRenderSurfaceSelector::externalRenderTargetSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="externalRenderTargetSize")
    @io.qt.QtUninvokable
    public final io.qt.core.QSize externalRenderTargetSize(){
        return externalRenderTargetSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize externalRenderTargetSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#setExternalRenderTargetSize">Qt3DRender::QRenderSurfaceSelector::setExternalRenderTargetSize(QSize)</a></p>
     */
    @io.qt.QtPropertyWriter(name="externalRenderTargetSize")
    public final void setExternalRenderTargetSize(io.qt.core.QSize size){
        setExternalRenderTargetSize_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    private native void setExternalRenderTargetSize_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#setSurface">Qt3DRender::QRenderSurfaceSelector::setSurface(QObject*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="surface")
    public final void setSurface(io.qt.core.QObject surfaceObject){
        setSurface_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(surfaceObject));
        __rcSurfaceObject = surfaceObject;
    }
    
    private native void setSurface_native_QObject_ptr(long __this__nativeId, long surfaceObject);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::setSurfacePixelRatio(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="surfacePixelRatio")
    public final void setSurfacePixelRatio(float ratio){
        setSurfacePixelRatio_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), ratio);
    }
    
    private native void setSurfacePixelRatio_native_float(long __this__nativeId, float ratio);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surface-prop">Qt3DRender::QRenderSurfaceSelector::surface()const</a></p>
     */
    @io.qt.QtPropertyReader(name="surface")
    @io.qt.QtUninvokable
    public final io.qt.core.QObject surface(){
        return surface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject surface_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qrendersurfaceselector.html#surfacePixelRatio-prop">Qt3DRender::QRenderSurfaceSelector::surfacePixelRatio()const</a></p>
     */
    @io.qt.QtPropertyReader(name="surfacePixelRatio")
    @io.qt.QtUninvokable
    public final float surfacePixelRatio(){
        return surfacePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float surfacePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QRenderSurfaceSelector(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QRenderSurfaceSelector(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QRenderSurfaceSelector instance, QDeclarativeConstructor constructor);
    
}
