package io.qt.qt3d.render;


/**
 * <p>A viewport on the Qt3D Scene</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qt3drender-qviewport.html">Qt3DRender::QViewport</a></p>
 */
public class QViewport extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QViewport.class);
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::gammaChanged(float)</a></p>
     */
    @io.qt.QtPropertyNotify(name="gamma")
    public final Signal1<@io.qt.QtPrimitiveType Float> gammaChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::normalizedRectChanged(QRectF)</a></p>
     */
    @io.qt.QtPropertyNotify(name="normalizedRect")
    public final Signal1<io.qt.core.QRectF> normalizedRectChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QViewport(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QViewport() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#QViewport">Qt3DRender::QViewport::QViewport(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QViewport(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QViewport instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::gamma()const</a></p>
     */
    @io.qt.QtPropertyReader(name="gamma")
    @io.qt.QtUninvokable
    public final float gamma(){
        return gamma_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float gamma_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::normalizedRect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="normalizedRect")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF normalizedRect(){
        return normalizedRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF normalizedRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::setGamma(float)</a></p>
     */
    @io.qt.QtPropertyWriter(name="gamma")
    public final void setGamma(float gamma){
        setGamma_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), gamma);
    }
    
    private native void setGamma_native_float(long __this__nativeId, float gamma);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::setNormalizedRect(QRectF)</a></p>
     */
    @io.qt.QtPropertyWriter(name="normalizedRect")
    public final void setNormalizedRect(io.qt.core.QRectF normalizedRect){
        setNormalizedRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(normalizedRect));
    }
    
    private native void setNormalizedRect_native_cref_QRectF(long __this__nativeId, long normalizedRect);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QViewport(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QViewport(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QViewport instance, QDeclarativeConstructor constructor);
    
}
