package io.qt.qt3d.render.quick.scene2d;


/**
 * <p>This class enables rendering qml into a texture, which then can be used as a part of 3D scene</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html">Qt3DRender::Quick::QScene2D</a></p>
 */
public class QScene2D extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScene2D.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#RenderPolicy-enum">Qt3DRender::Quick::QScene2D::RenderPolicy</a></p>
     */
    public enum RenderPolicy implements io.qt.QtEnumerator {
        Continuous(0),
        SingleShot(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderPolicy resolve(int value) {
            switch (value) {
            case 0: return Continuous;
            case 1: return SingleShot;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::itemChanged(QQuickItem*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="item")
    public final Signal1<io.qt.quick.QQuickItem> itemChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::mouseEnabledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mouseEnabled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> mouseEnabledChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::outputChanged(Qt3DRender::QRenderTargetOutput*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtPropertyNotify(name="output")
    public final Signal1<io.qt.qt3d.render.QRenderTargetOutput> outputChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::renderPolicyChanged(Qt3DRender::Quick::QScene2D::RenderPolicy)</a></p>
     */
    @io.qt.QtPropertyNotify(name="renderPolicy")
    public final Signal1<io.qt.qt3d.render.quick.scene2d.QScene2D.RenderPolicy> renderPolicyChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QScene2D(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QScene2D() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#QScene2D">Qt3DRender::Quick::QScene2D::QScene2D(Qt3DCore::QNode*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QScene2D(io.qt.qt3d.core.QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScene2D instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#addEntity">Qt3DRender::Quick::QScene2D::addEntity(Qt3DCore::QEntity*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void addEntity(io.qt.qt3d.core.QEntity entity){
        addEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    @io.qt.QtUninvokable
    private native void addEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#entities">Qt3DRender::Quick::QScene2D::entities()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qt3d.core.QEntity> entities(){
        return entities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.core.QEntity> entities_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::isMouseEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mouseEnabled")
    @io.qt.QtUninvokable
    public final boolean isMouseEnabled(){
        return isMouseEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isMouseEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::item()const</a></p>
     */
    @io.qt.QtPropertyReader(name="item")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem item(){
        return item_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem item_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::output()const</a></p>
     */
    @io.qt.QtPropertyReader(name="output")
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput output(){
        return output_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qt3d.render.QRenderTargetOutput output_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#removeEntity">Qt3DRender::Quick::QScene2D::removeEntity(Qt3DCore::QEntity*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void removeEntity(io.qt.qt3d.core.QEntity entity){
        removeEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    @io.qt.QtUninvokable
    private native void removeEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::renderPolicy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="renderPolicy")
    @io.qt.QtUninvokable
    public final io.qt.qt3d.render.quick.scene2d.QScene2D.RenderPolicy renderPolicy(){
        return io.qt.qt3d.render.quick.scene2d.QScene2D.RenderPolicy.resolve(renderPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int renderPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::setItem(QQuickItem*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="item")
    @SuppressWarnings({"exports"})
    public final void setItem(io.qt.quick.QQuickItem item){
        setItem_native_QQuickItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    private native void setItem_native_QQuickItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::setMouseEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mouseEnabled")
    public final void setMouseEnabled(boolean enabled){
        setMouseEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setMouseEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::setOutput(Qt3DRender::QRenderTargetOutput*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="output")
    @SuppressWarnings({"exports"})
    public final void setOutput(io.qt.qt3d.render.QRenderTargetOutput output){
        setOutput_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
    }
    
    private native void setOutput_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::setRenderPolicy(Qt3DRender::Quick::QScene2D::RenderPolicy)</a></p>
     */
    @io.qt.QtPropertyWriter(name="renderPolicy")
    public final void setRenderPolicy(io.qt.qt3d.render.quick.scene2d.QScene2D.RenderPolicy policy){
        setRenderPolicy_native_Qt3DRender_Quick_QScene2D_RenderPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    private native void setRenderPolicy_native_Qt3DRender_Quick_QScene2D_RenderPolicy(long __this__nativeId, int policy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QScene2D(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QScene2D(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QScene2D instance, QDeclarativeConstructor constructor);
    
}
