package io.qt.qt3d.render.quick.scene2d;

import io.qt.*;


/**
 * <p>This class enables rendering qml into a texture, which then can be used as a part of 3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html">Qt3DRender::Quick::QScene2D</a></code></p>
 */
public class QScene2D extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QScene2D.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#RenderPolicy-enum">Qt3DRender::Quick::QScene2D::RenderPolicy</a></code></p>
     */
    public enum RenderPolicy implements QtEnumerator {
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#RenderPolicy-enum">Qt3DRender::<wbr/>Quick::<wbr/>QScene2D::<wbr/>Continuous</a></code></p>
         */
        Continuous(0),
        /**
         * <p>Representing <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#RenderPolicy-enum">Qt3DRender::<wbr/>Quick::<wbr/>QScene2D::<wbr/>SingleShot</a></code></p>
         */
        SingleShot(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RenderPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RenderPolicy resolve(int value) {
            switch (value) {
            case 0: return Continuous;
            case 1: return SingleShot;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::<wbr/>itemChanged(QQuickItem*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="item")
    public final @NonNull Signal1<io.qt.quick.@Nullable QQuickItem> itemChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::<wbr/>mouseEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="mouseEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> mouseEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::<wbr/>outputChanged(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="output")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QRenderTargetOutput> outputChanged = new Signal1<>();

    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::<wbr/>renderPolicyChanged(Qt3DRender::Quick::QScene2D::RenderPolicy)</a></code></p>
     */
    @QtPropertyNotify(name="renderPolicy")
    public final @NonNull Signal1<io.qt.qt3d.render.quick.scene2d.QScene2D.@NonNull RenderPolicy> renderPolicyChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#QScene2D">Qt3DRender::Quick::QScene2D::<wbr/>QScene2D(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QScene2D(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QScene2D instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#addEntity">Qt3DRender::Quick::QScene2D::<wbr/>addEntity(Qt3DCore::QEntity*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void addEntity(io.qt.qt3d.core.@Nullable QEntity entity){
        addEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    @QtUninvokable
    private native void addEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#entities-1">Qt3DRender::Quick::QScene2D::<wbr/>entities()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.core.@NonNull QVector<io.qt.qt3d.core.@Nullable QEntity> entities(){
        return entities_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QVector<io.qt.qt3d.core.QEntity> entities_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::<wbr/>isMouseEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="mouseEnabled")
    @QtUninvokable
    public final boolean isMouseEnabled(){
        return isMouseEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMouseEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::<wbr/>item()const</a></code></p>
     */
    @QtPropertyReader(name="item")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.quick.@Nullable QQuickItem item(){
        return item_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.quick.QQuickItem item_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::<wbr/>output()const</a></code></p>
     */
    @QtPropertyReader(name="output")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTargetOutput output(){
        return output_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderTargetOutput output_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#removeEntity">Qt3DRender::Quick::QScene2D::<wbr/>removeEntity(Qt3DCore::QEntity*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void removeEntity(io.qt.qt3d.core.@Nullable QEntity entity){
        removeEntity_native_Qt3DCore_QEntity_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(entity));
    }
    
    @QtUninvokable
    private native void removeEntity_native_Qt3DCore_QEntity_ptr(long __this__nativeId, long entity);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::<wbr/>renderPolicy()const</a></code></p>
     */
    @QtPropertyReader(name="renderPolicy")
    @QtUninvokable
    public final io.qt.qt3d.render.quick.scene2d.QScene2D.@NonNull RenderPolicy renderPolicy(){
        return io.qt.qt3d.render.quick.scene2d.QScene2D.RenderPolicy.resolve(renderPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int renderPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#item-prop">Qt3DRender::Quick::QScene2D::<wbr/>setItem(QQuickItem*)</a></code></p>
     */
    @QtPropertyWriter(name="item")
    @SuppressWarnings({"exports"})
    public final void setItem(io.qt.quick.@Nullable QQuickItem item){
        setItem_native_QQuickItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
    }
    
    private native void setItem_native_QQuickItem_ptr(long __this__nativeId, long item);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#mouseEnabled-prop">Qt3DRender::Quick::QScene2D::<wbr/>setMouseEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="mouseEnabled")
    public final void setMouseEnabled(boolean enabled){
        setMouseEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setMouseEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#output-prop">Qt3DRender::Quick::QScene2D::<wbr/>setOutput(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @QtPropertyWriter(name="output")
    @SuppressWarnings({"exports"})
    public final void setOutput(io.qt.qt3d.render.@Nullable QRenderTargetOutput output){
        setOutput_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
    }
    
    private native void setOutput_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <code><a href="http://doc.qt.io/qt-5/qt3drender-quick-qscene2d.html#renderPolicy-prop">Qt3DRender::Quick::QScene2D::<wbr/>setRenderPolicy(Qt3DRender::Quick::QScene2D::RenderPolicy)</a></code></p>
     */
    @QtPropertyWriter(name="renderPolicy")
    public final void setRenderPolicy(io.qt.qt3d.render.quick.scene2d.QScene2D.@NonNull RenderPolicy policy){
        setRenderPolicy_native_Qt3DRender_Quick_QScene2D_RenderPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    private native void setRenderPolicy_native_Qt3DRender_Quick_QScene2D_RenderPolicy(long __this__nativeId, int policy);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QScene2D(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QScene2D(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QScene2D instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QScene2D(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QScene2D() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isMouseEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMouseEnabled() {
        return isMouseEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #item()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.quick.@Nullable QQuickItem getItem() {
        return item();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #output()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTargetOutput getOutput() {
        return output();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #renderPolicy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.quick.scene2d.QScene2D.@NonNull RenderPolicy getRenderPolicy() {
        return renderPolicy();
    }
}
