package io.qt.qt3d.logic;

import io.qt.*;
import static io.qt.QtUtilities.*;

/**
 * @hidden
 */
final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 6;

    final static int qtMinorVersion = 5;

    final static int qtJambiPatch = 4;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("EglFSDeviceIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Network", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("OpenGL", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Pdf", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WaylandEglClientHwIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("XcbQpa", LibraryRequirementMode.ProvideOnly, "linux");
            loadUtilityLibrary("d3dcompiler_47", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("libEGL", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("libGLESv2", LibraryRequirementMode.ProvideOnly, "windows");
            loadUtilityLibrary("opengl32sw", LibraryRequirementMode.ProvideOnly, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Concurrent", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Network", LibraryRequirementMode.Mandatory);
            loadQtLibrary("3DCore", LibraryRequirementMode.Mandatory);
            loadQtLibrary("3DLogic", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("3DLogic");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

