package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Represents a set of QAbstractActionInput's that must be triggerd one after the other</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html">Qt3DInput::QInputSequence</a></code></p>
 */
public class QInputSequence extends io.qt.qt3d.input.QAbstractActionInput
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QInputSequence.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#buttonInterval-prop">Qt3DInput::QInputSequence::<wbr/>buttonIntervalChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="buttonInterval")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> buttonIntervalChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#timeout-prop">Qt3DInput::QInputSequence::<wbr/>timeoutChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="timeout")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> timeoutChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#QInputSequence">Qt3DInput::QInputSequence::<wbr/>QInputSequence(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QInputSequence(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QInputSequence instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#addSequence">Qt3DInput::QInputSequence::<wbr/>addSequence(Qt3DInput::QAbstractActionInput*)</a></code></p>
     */
    @QtUninvokable
    public final void addSequence(io.qt.qt3d.input.@Nullable QAbstractActionInput input){
        addSequence_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void addSequence_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#buttonInterval">Qt3DInput::QInputSequence::<wbr/>buttonInterval()const</a></code></p>
     */
    @QtPropertyReader(name="buttonInterval")
    @QtUninvokable
    public final int buttonInterval(){
        return buttonInterval_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int buttonInterval_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#removeSequence">Qt3DInput::QInputSequence::<wbr/>removeSequence(Qt3DInput::QAbstractActionInput*)</a></code></p>
     */
    @QtUninvokable
    public final void removeSequence(io.qt.qt3d.input.@Nullable QAbstractActionInput input){
        removeSequence_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void removeSequence_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#sequences">Qt3DInput::QInputSequence::<wbr/>sequences()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.input.@Nullable QAbstractActionInput> sequences(){
        return sequences_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAbstractActionInput> sequences_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#buttonInterval-prop">Qt3DInput::QInputSequence::<wbr/>setButtonInterval(int)</a></code></p>
     */
    @QtPropertyWriter(name="buttonInterval")
    public final void setButtonInterval(int buttonInterval){
        setButtonInterval_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), buttonInterval);
    }
    
    private native void setButtonInterval_native_int(long __this__nativeId, int buttonInterval);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#timeout-prop">Qt3DInput::QInputSequence::<wbr/>setTimeout(int)</a></code></p>
     */
    @QtPropertyWriter(name="timeout")
    public final void setTimeout(int timeout){
        setTimeout_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    private native void setTimeout_native_int(long __this__nativeId, int timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputsequence.html#timeout">Qt3DInput::QInputSequence::<wbr/>timeout()const</a></code></p>
     */
    @QtPropertyReader(name="timeout")
    @QtUninvokable
    public final int timeout(){
        return timeout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int timeout_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QInputSequence(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QInputSequence(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QInputSequence instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QInputSequence(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QInputSequence() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttonInterval()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getButtonInterval() {
        return buttonInterval();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #timeout()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTimeout() {
        return timeout();
    }
}
