package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Processes velocity or acceleration data from a QAxis</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html">Qt3DInput::QAxisAccumulator</a></code></p>
 */
public class QAxisAccumulator extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxisAccumulator.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#SourceAxisType-enum">Qt3DInput::QAxisAccumulator::SourceAxisType</a></code></p>
     */
    public enum SourceAxisType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#SourceAxisType-enum">Qt3DInput::<wbr/>QAxisAccumulator::<wbr/>Velocity</a></code></p>
         */
        Velocity(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#SourceAxisType-enum">Qt3DInput::<wbr/>QAxisAccumulator::<wbr/>Acceleration</a></code></p>
         */
        Acceleration(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SourceAxisType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SourceAxisType resolve(int value) {
            switch (value) {
            case 0: return Velocity;
            case 1: return Acceleration;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale-prop">Qt3DInput::QAxisAccumulator::<wbr/>scaleChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="scale")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> scaleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxis-prop">Qt3DInput::QAxisAccumulator::<wbr/>sourceAxisChanged(Qt3DInput::QAxis*)</a></code></p>
     */
    @QtPropertyNotify(name="sourceAxis")
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QAxis> sourceAxisChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxisType-prop">Qt3DInput::QAxisAccumulator::<wbr/>sourceAxisTypeChanged(Qt3DInput::QAxisAccumulator::SourceAxisType)</a></code></p>
     */
    @QtPropertyNotify(name="sourceAxisType")
    public final @NonNull Signal1<io.qt.qt3d.input.QAxisAccumulator.@NonNull SourceAxisType> sourceAxisTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#value-prop">Qt3DInput::QAxisAccumulator::<wbr/>valueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="value")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> valueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#velocity-prop">Qt3DInput::QAxisAccumulator::<wbr/>velocityChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="velocity")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> velocityChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#QAxisAccumulator">Qt3DInput::QAxisAccumulator::<wbr/>QAxisAccumulator(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAxisAccumulator(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxisAccumulator instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale">Qt3DInput::QAxisAccumulator::<wbr/>scale()const</a></code></p>
     */
    @QtPropertyReader(name="scale")
    @QtUninvokable
    public final float scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#scale-prop">Qt3DInput::QAxisAccumulator::<wbr/>setScale(float)</a></code></p>
     */
    @QtPropertyWriter(name="scale")
    public final void setScale(float scale){
        setScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setScale_native_float(long __this__nativeId, float scale);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#setSourceAxis">Qt3DInput::QAxisAccumulator::<wbr/>setSourceAxis(Qt3DInput::QAxis*)</a></code></p>
     */
    @QtPropertyWriter(name="sourceAxis")
    public final void setSourceAxis(io.qt.qt3d.input.@Nullable QAxis sourceAxis){
        setSourceAxis_native_Qt3DInput_QAxis_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceAxis));
    }
    
    private native void setSourceAxis_native_Qt3DInput_QAxis_ptr(long __this__nativeId, long sourceAxis);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#setSourceAxisType">Qt3DInput::QAxisAccumulator::<wbr/>setSourceAxisType(Qt3DInput::QAxisAccumulator::SourceAxisType)</a></code></p>
     */
    @QtPropertyWriter(name="sourceAxisType")
    public final void setSourceAxisType(io.qt.qt3d.input.QAxisAccumulator.@NonNull SourceAxisType sourceAxisType){
        setSourceAxisType_native_Qt3DInput_QAxisAccumulator_SourceAxisType(QtJambi_LibraryUtilities.internal.nativeId(this), sourceAxisType.value());
    }
    
    private native void setSourceAxisType_native_Qt3DInput_QAxisAccumulator_SourceAxisType(long __this__nativeId, int sourceAxisType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxis">Qt3DInput::QAxisAccumulator::<wbr/>sourceAxis()const</a></code></p>
     */
    @QtPropertyReader(name="sourceAxis")
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QAxis sourceAxis(){
        return sourceAxis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.input.QAxis sourceAxis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#sourceAxisType">Qt3DInput::QAxisAccumulator::<wbr/>sourceAxisType()const</a></code></p>
     */
    @QtPropertyReader(name="sourceAxisType")
    @QtUninvokable
    public final io.qt.qt3d.input.QAxisAccumulator.@NonNull SourceAxisType sourceAxisType(){
        return io.qt.qt3d.input.QAxisAccumulator.SourceAxisType.resolve(sourceAxisType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int sourceAxisType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#value-prop">Qt3DInput::QAxisAccumulator::<wbr/>value()const</a></code></p>
     */
    @QtPropertyReader(name="value")
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxisaccumulator.html#velocity">Qt3DInput::QAxisAccumulator::<wbr/>velocity()const</a></code></p>
     */
    @QtPropertyReader(name="velocity")
    @QtUninvokable
    public final float velocity(){
        return velocity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float velocity_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxisAccumulator(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAxisAccumulator(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxisAccumulator instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxisAccumulator(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxisAccumulator() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getScale() {
        return scale();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceAxis()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QAxis getSourceAxis() {
        return sourceAxis();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceAxisType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.QAxisAccumulator.@NonNull SourceAxisType getSourceAxisType() {
        return sourceAxisType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #value()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getValue() {
        return value();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #velocity()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getVelocity() {
        return velocity();
    }
}
