package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Links a set of QAbstractActionInput that trigger the same event</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html">Qt3DInput::QAction</a></code></p>
 */
public class QAction extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAction.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#active-prop">Qt3DInput::QAction::<wbr/>activeChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="active")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> activeChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#QAction">Qt3DInput::QAction::<wbr/>QAction(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAction(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAction instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#addInput">Qt3DInput::QAction::<wbr/>addInput(Qt3DInput::QAbstractActionInput*)</a></code></p>
     */
    @QtUninvokable
    public final void addInput(io.qt.qt3d.input.@Nullable QAbstractActionInput input){
        addInput_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void addInput_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#inputs">Qt3DInput::QAction::<wbr/>inputs()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.input.@Nullable QAbstractActionInput> inputs(){
        return inputs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAbstractActionInput> inputs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#active-prop">Qt3DInput::QAction::<wbr/>isActive()const</a></code></p>
     */
    @QtPropertyReader(name="active")
    @QtUninvokable
    public final boolean isActive(){
        return isActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaction.html#removeInput">Qt3DInput::QAction::<wbr/>removeInput(Qt3DInput::QAbstractActionInput*)</a></code></p>
     */
    @QtUninvokable
    public final void removeInput(io.qt.qt3d.input.@Nullable QAbstractActionInput input){
        removeInput_native_Qt3DInput_QAbstractActionInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void removeInput_native_Qt3DInput_QAbstractActionInput_ptr(long __this__nativeId, long input);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAction(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAction(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAction instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAction(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAction() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isActive()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getActive() {
        return isActive();
    }
}
