package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>The base class used by Qt3d to interact with arbitrary input devices</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html">Qt3DInput::QAbstractPhysicalDevice</a></code></p>
 */
public class QAbstractPhysicalDevice extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractPhysicalDevice.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#QAbstractPhysicalDevice">Qt3DInput::QAbstractPhysicalDevice::<wbr/>QAbstractPhysicalDevice(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractPhysicalDevice(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractPhysicalDevice instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#addAxisSetting">Qt3DInput::QAbstractPhysicalDevice::<wbr/>addAxisSetting(Qt3DInput::QAxisSetting*)</a></code></p>
     */
    @QtUninvokable
    public final void addAxisSetting(io.qt.qt3d.input.@Nullable QAxisSetting axisSetting){
        addAxisSetting_native_Qt3DInput_QAxisSetting_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axisSetting));
    }
    
    @QtUninvokable
    private native void addAxisSetting_native_Qt3DInput_QAxisSetting_ptr(long __this__nativeId, long axisSetting);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisSettings">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisSettings()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.input.@Nullable QAxisSetting> axisSettings(){
        return axisSettings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAxisSetting> axisSettings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#removeAxisSetting">Qt3DInput::QAbstractPhysicalDevice::<wbr/>removeAxisSetting(Qt3DInput::QAxisSetting*)</a></code></p>
     */
    @QtUninvokable
    public final void removeAxisSetting(io.qt.qt3d.input.@Nullable QAxisSetting axisSetting){
        removeAxisSetting_native_Qt3DInput_QAxisSetting_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(axisSetting));
    }
    
    @QtUninvokable
    private native void removeAxisSetting_native_Qt3DInput_QAxisSetting_ptr(long __this__nativeId, long axisSetting);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisCount()const</a></code></p>
     */
    @QtUninvokable
    public int axisCount(){
        return axisCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int axisCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisIdentifier(QString)const</a></code></p>
     */
    @QtUninvokable
    public int axisIdentifier(java.lang.@NonNull String name){
        return axisIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native int axisIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisNames()const</a></code></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> axisNames(){
        return axisNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> axisNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonCount()const</a></code></p>
     */
    @QtUninvokable
    public int buttonCount(){
        return buttonCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int buttonCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonIdentifier(QString)const</a></code></p>
     */
    @QtUninvokable
    public int buttonIdentifier(java.lang.@NonNull String name){
        return buttonIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native int buttonIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonNames()const</a></code></p>
     */
    @QtUninvokable
    public java.util.@NonNull List<java.lang.@NonNull String> buttonNames(){
        return buttonNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.List<java.lang.String> buttonNames_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractPhysicalDevice(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractPhysicalDevice(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractPhysicalDevice instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractPhysicalDevice(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractPhysicalDevice() {
        this((io.qt.qt3d.core.QNode)null);
    }
}
