package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>In charge of dispatching keyboard events to attached QQKeyboardHandler objects</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyboarddevice.html">Qt3DInput::QKeyboardDevice</a></code></p>
 */
public class QKeyboardDevice extends io.qt.qt3d.input.QAbstractPhysicalDevice
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QKeyboardDevice.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyboarddevice.html#activeInput-prop">Qt3DInput::QKeyboardDevice::<wbr/>activeInputChanged(Qt3DInput::QKeyboardHandler*)</a></code></p>
     */
    @QtPropertyNotify(name="activeInput")
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QKeyboardHandler> activeInputChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyboarddevice.html#QKeyboardDevice">Qt3DInput::QKeyboardDevice::<wbr/>QKeyboardDevice(QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QKeyboardDevice(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QKeyboardDevice instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyboarddevice.html#activeInput-prop">Qt3DInput::QKeyboardDevice::<wbr/>activeInput()const</a></code></p>
     */
    @QtPropertyReader(name="activeInput")
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QKeyboardHandler activeInput(){
        return activeInput_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.input.QKeyboardHandler activeInput_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisCount()const</a></code></p>
     */
    public final int axisCount(){
        return axisCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int axisCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisIdentifier(QString)const</a></code></p>
     */
    public final int axisIdentifier(java.lang.@NonNull String name){
        return axisIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int axisIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#axisNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>axisNames()const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList axisNames(){
        return axisNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList axisNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonCount">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonCount()const</a></code></p>
     */
    public final int buttonCount(){
        return buttonCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native int buttonCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonIdentifier">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonIdentifier(QString)const</a></code></p>
     */
    public final int buttonIdentifier(java.lang.@NonNull String name){
        return buttonIdentifier_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native int buttonIdentifier_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qabstractphysicaldevice.html#buttonNames">Qt3DInput::QAbstractPhysicalDevice::<wbr/>buttonNames()const</a></code></p>
     */
    public final io.qt.core.@NonNull QStringList buttonNames(){
        return buttonNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native io.qt.core.QStringList buttonNames_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QKeyboardDevice(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QKeyboardDevice(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QKeyboardDevice instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QKeyboardDevice(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QKeyboardDevice() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #activeInput()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QKeyboardHandler getActiveInput() {
        return activeInput();
    }
}
