package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Responsible for creating physical devices and handling associated jobs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qinputaspect.html">Qt3DInput::QInputAspect</a></code></p>
 */
public class QInputAspect extends io.qt.qt3d.core.QAbstractAspect
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QInputAspect.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputaspect.html#QInputAspect">Qt3DInput::QInputAspect::<wbr/>QInputAspect(QObject*)</a></code></p>
     */
    public QInputAspect(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QInputAspect instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputaspect.html#availablePhysicalDevices">Qt3DInput::QInputAspect::<wbr/>availablePhysicalDevices()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList availablePhysicalDevices(){
        return availablePhysicalDevices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList availablePhysicalDevices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qinputaspect.html#createPhysicalDevice">Qt3DInput::QInputAspect::<wbr/>createPhysicalDevice(QString)</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QAbstractPhysicalDevice createPhysicalDevice(java.lang.@NonNull String name){
        return createPhysicalDevice_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.qt3d.input.QAbstractPhysicalDevice createPhysicalDevice_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QInputAspect(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QInputAspect(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QInputAspect instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QInputAspect(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QInputAspect() {
        this((io.qt.core.QObject)null);
    }
}
