package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>An axis input controlled by buttons The axis value is controlled by buttons rather than a traditional analog input such as a joystick</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html">Qt3DInput::QButtonAxisInput</a></code></p>
 */
public class QButtonAxisInput extends io.qt.qt3d.input.QAbstractAxisInput
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QButtonAxisInput.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#acceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>accelerationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="acceleration")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> accelerationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#buttons-prop">Qt3DInput::QButtonAxisInput::<wbr/>buttonsChanged(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="buttons")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@QtPrimitiveType@NonNull Integer>> buttonsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#deceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>decelerationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="deceleration")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> decelerationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#scale-prop">Qt3DInput::QButtonAxisInput::<wbr/>scaleChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="scale")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> scaleChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#QButtonAxisInput">Qt3DInput::QButtonAxisInput::<wbr/>QButtonAxisInput(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QButtonAxisInput(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QButtonAxisInput instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#acceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>acceleration()const</a></code></p>
     */
    @QtPropertyReader(name="acceleration")
    @QtUninvokable
    public final float acceleration(){
        return acceleration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float acceleration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#buttons-prop">Qt3DInput::QButtonAxisInput::<wbr/>buttons()const</a></code></p>
     */
    @QtPropertyReader(name="buttons")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#deceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>deceleration()const</a></code></p>
     */
    @QtPropertyReader(name="deceleration")
    @QtUninvokable
    public final float deceleration(){
        return deceleration_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float deceleration_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#scale-prop">Qt3DInput::QButtonAxisInput::<wbr/>scale()const</a></code></p>
     */
    @QtPropertyReader(name="scale")
    @QtUninvokable
    public final float scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#acceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>setAcceleration(float)</a></code></p>
     */
    @QtPropertyWriter(name="acceleration")
    public final void setAcceleration(float acceleration){
        setAcceleration_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), acceleration);
    }
    
    private native void setAcceleration_native_float(long __this__nativeId, float acceleration);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#buttons-prop">Qt3DInput::QButtonAxisInput::<wbr/>setButtons(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="buttons")
    public final void setButtons(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> buttons){
        setButtons_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), buttons);
    }
    
    private native void setButtons_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> buttons);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#deceleration-prop">Qt3DInput::QButtonAxisInput::<wbr/>setDeceleration(float)</a></code></p>
     */
    @QtPropertyWriter(name="deceleration")
    public final void setDeceleration(float deceleration){
        setDeceleration_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), deceleration);
    }
    
    private native void setDeceleration_native_float(long __this__nativeId, float deceleration);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qbuttonaxisinput.html#scale-prop">Qt3DInput::QButtonAxisInput::<wbr/>setScale(float)</a></code></p>
     */
    @QtPropertyWriter(name="scale")
    public final void setScale(float scale){
        setScale_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scale);
    }
    
    private native void setScale_native_float(long __this__nativeId, float scale);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QButtonAxisInput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QButtonAxisInput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QButtonAxisInput instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QButtonAxisInput(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QButtonAxisInput() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #acceleration()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getAcceleration() {
        return acceleration();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttons()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getButtons() {
        return buttons();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #deceleration()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDeceleration() {
        return deceleration();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #scale()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getScale() {
        return scale();
    }
}
