package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Stores Device and Buttons used to trigger an input event</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html">Qt3DInput::QActionInput</a></code></p>
 */
public class QActionInput extends io.qt.qt3d.input.QAbstractActionInput
{
    @QtPropertyMember(enabled=false)
    private Object __rcSourceDevice = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QActionInput.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#buttonsChanged">Qt3DInput::QActionInput::<wbr/>buttonsChanged(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="buttons")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@QtPrimitiveType@NonNull Integer>> buttonsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#sourceDeviceChanged">Qt3DInput::QActionInput::<wbr/>sourceDeviceChanged(Qt3DInput::QAbstractPhysicalDevice*)</a></code></p>
     */
    @QtPropertyNotify(name="sourceDevice")
    public final @NonNull Signal1<io.qt.qt3d.input.@Nullable QAbstractPhysicalDevice> sourceDeviceChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#QActionInput">Qt3DInput::QActionInput::<wbr/>QActionInput(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QActionInput(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QActionInput instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#buttons-prop">Qt3DInput::QActionInput::<wbr/>buttons()const</a></code></p>
     */
    @QtPropertyReader(name="buttons")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#setButtons">Qt3DInput::QActionInput::<wbr/>setButtons(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="buttons")
    public final void setButtons(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> buttons){
        setButtons_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), buttons);
    }
    
    private native void setButtons_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> buttons);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#sourceDevice-prop">Qt3DInput::QActionInput::<wbr/>setSourceDevice(Qt3DInput::QAbstractPhysicalDevice*)</a></code></p>
     */
    @QtPropertyWriter(name="sourceDevice")
    public final void setSourceDevice(io.qt.qt3d.input.@Nullable QAbstractPhysicalDevice sourceDevice){
        setSourceDevice_native_Qt3DInput_QAbstractPhysicalDevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceDevice));
        __rcSourceDevice = sourceDevice;
    }
    
    private native void setSourceDevice_native_Qt3DInput_QAbstractPhysicalDevice_ptr(long __this__nativeId, long sourceDevice);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qactioninput.html#sourceDevice-prop">Qt3DInput::QActionInput::<wbr/>sourceDevice()const</a></code></p>
     */
    @QtPropertyReader(name="sourceDevice")
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QAbstractPhysicalDevice sourceDevice(){
        return sourceDevice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.input.QAbstractPhysicalDevice sourceDevice_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QActionInput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QActionInput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QActionInput instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QActionInput(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QActionInput() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #buttons()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getButtons() {
        return buttons();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sourceDevice()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.@Nullable QAbstractPhysicalDevice getSourceDevice() {
        return sourceDevice();
    }
}
