package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Contains parameters that describe a mouse wheel event</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html">Qt3DInput::QWheelEvent</a></code></p>
 */
public class QWheelEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWheelEvent.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::QWheelEvent::Buttons</a></code></p>
     */
    public enum Buttons implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>LeftButton</a></code></p>
         */
        LeftButton(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>RightButton</a></code></p>
         */
        RightButton(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>MiddleButton</a></code></p>
         */
        MiddleButton(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>BackButton</a></code></p>
         */
        BackButton(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Buttons-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>NoButton</a></code></p>
         */
        NoButton(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Buttons(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Buttons resolve(int value) {
            switch (value) {
            case 1: return LeftButton;
            case 2: return RightButton;
            case 4: return MiddleButton;
            case 8: return BackButton;
            case 0: return NoButton;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::QWheelEvent::Modifiers</a></code></p>
     */
    public enum Modifiers implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>NoModifier</a></code></p>
         */
        NoModifier(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>ShiftModifier</a></code></p>
         */
        ShiftModifier(33554432),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>ControlModifier</a></code></p>
         */
        ControlModifier(67108864),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>AltModifier</a></code></p>
         */
        AltModifier(134217728),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>MetaModifier</a></code></p>
         */
        MetaModifier(268435456),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#Modifiers-enum">Qt3DInput::<wbr>QWheelEvent::<wbr>KeypadModifier</a></code></p>
         */
        KeypadModifier(536870912);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Modifiers(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Modifiers resolve(int value) {
            switch (value) {
            case 0: return NoModifier;
            case 33554432: return ShiftModifier;
            case 67108864: return ControlModifier;
            case 134217728: return AltModifier;
            case 268435456: return MetaModifier;
            case 536870912: return KeypadModifier;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#QWheelEvent">Qt3DInput::QWheelEvent::<wbr>QWheelEvent(::QWheelEvent)</a></code></p>
     */
    public QWheelEvent(io.qt.gui.@StrictNonNull QWheelEvent e){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(e, "Argument 'e': null not expected.");
        initialize_native(this, e);
    }
    
    private native static void initialize_native(QWheelEvent instance, io.qt.gui.QWheelEvent e);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#angleDelta">Qt3DInput::QWheelEvent::<wbr>angleDelta()const</a></code></p>
     */
    @QtPropertyReader(name="angleDelta")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint angleDelta(){
        return angleDelta_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint angleDelta_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#buttons">Qt3DInput::QWheelEvent::<wbr>buttons()const</a></code></p>
     */
    @QtPropertyReader(name="buttons")
    @QtPropertyConstant
    @QtUninvokable
    public final int buttons(){
        return buttons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int buttons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#isAccepted">Qt3DInput::QWheelEvent::<wbr>isAccepted()const</a></code></p>
     */
    @QtPropertyReader(name="accepted")
    @QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#modifiers">Qt3DInput::QWheelEvent::<wbr>modifiers()const</a></code></p>
     */
    @QtPropertyReader(name="modifiers")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.input.QWheelEvent.@NonNull Modifiers modifiers(){
        return io.qt.qt3d.input.QWheelEvent.Modifiers.resolve(modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#setAccepted">Qt3DInput::QWheelEvent::<wbr>setAccepted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="accepted")
    @QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#type">Qt3DInput::QWheelEvent::<wbr>type()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.QEvent.@NonNull Type type(){
        return io.qt.core.QEvent.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#x">Qt3DInput::QWheelEvent::<wbr>x()const</a></code></p>
     */
    @QtPropertyReader(name="x")
    @QtPropertyConstant
    @QtUninvokable
    public final int x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qwheelevent.html#y">Qt3DInput::QWheelEvent::<wbr>y()const</a></code></p>
     */
    @QtPropertyReader(name="y")
    @QtPropertyConstant
    @QtUninvokable
    public final int y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int y_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWheelEvent(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #angleDelta()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getAngleDelta() {
        return angleDelta();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #buttons()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getButtons() {
        return buttons();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAccepted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAccepted() {
        return isAccepted();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #modifiers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.input.QWheelEvent.@NonNull Modifiers getModifiers() {
        return modifiers();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #x()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getX() {
        return x();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #y()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getY() {
        return y();
    }
}
