package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Event type send by KeyBoardHandler</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html">Qt3DInput::QKeyEvent</a></code></p>
 */
public class QKeyEvent extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QKeyEvent.class);
    
    
    /**
     * <p>See <code>Qt3DInput::QKeyEvent::<wbr>QKeyEvent(QEvent::Type,<wbr>int,<wbr>Qt::KeyboardModifiers,<wbr>QString,<wbr>bool,<wbr>ushort)</code></p>
     */
    public QKeyEvent(io.qt.core.QEvent.@NonNull Type type, int key, io.qt.core.Qt.@NonNull KeyboardModifiers modifiers, java.lang.@NonNull String text, boolean autorep, short count){
        super((QPrivateConstructor)null);
        initialize_native(this, type, key, modifiers, text, autorep, count);
    }
    
    private native static void initialize_native(QKeyEvent instance, io.qt.core.QEvent.Type type, int key, io.qt.core.Qt.KeyboardModifiers modifiers, java.lang.String text, boolean autorep, short count);
    
    /**
     * <p>See <code>Qt3DInput::QKeyEvent::<wbr>QKeyEvent(::QKeyEvent)</code></p>
     */
    public QKeyEvent(io.qt.gui.@StrictNonNull QKeyEvent ke){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(ke, "Argument 'ke': null not expected.");
        initialize_native(this, ke);
    }
    
    private native static void initialize_native(QKeyEvent instance, io.qt.gui.QKeyEvent ke);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#count-prop">Qt3DInput::QKeyEvent::<wbr>count()const</a></code></p>
     */
    @QtPropertyReader(name="count")
    @QtPropertyConstant
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#accepted-prop">Qt3DInput::QKeyEvent::<wbr>isAccepted()const</a></code></p>
     */
    @QtPropertyReader(name="accepted")
    @QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#isAutoRepeat-prop">Qt3DInput::QKeyEvent::<wbr>isAutoRepeat()const</a></code></p>
     */
    @QtPropertyReader(name="isAutoRepeat")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isAutoRepeat(){
        return isAutoRepeat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoRepeat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#key-prop">Qt3DInput::QKeyEvent::<wbr>key()const</a></code></p>
     */
    @QtPropertyReader(name="key")
    @QtPropertyConstant
    @QtUninvokable
    public final int key(){
        return key_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int key_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#matches">Qt3DInput::QKeyEvent::<wbr>matches(QKeySequence::StandardKey)const</a></code></p>
     */
    public final boolean matches(io.qt.gui.QKeySequence.@NonNull StandardKey key_){
        return matches_native_QKeySequence_StandardKey_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), key_.value());
    }
    
    private native boolean matches_native_QKeySequence_StandardKey_constfct(long __this__nativeId, int key_);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#modifiers-prop">Qt3DInput::QKeyEvent::<wbr>modifiers()const</a></code></p>
     */
    @QtPropertyReader(name="modifiers")
    @QtPropertyConstant
    @QtUninvokable
    public final int modifiers(){
        return modifiers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int modifiers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#nativeScanCode-prop">Qt3DInput::QKeyEvent::<wbr>nativeScanCode()const</a></code></p>
     */
    @QtPropertyReader(name="nativeScanCode")
    @QtPropertyConstant
    @QtUninvokable
    public final int nativeScanCode(){
        return nativeScanCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int nativeScanCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#accepted-prop">Qt3DInput::QKeyEvent::<wbr>setAccepted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="accepted")
    @QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#text-prop">Qt3DInput::QKeyEvent::<wbr>text()const</a></code></p>
     */
    @QtPropertyReader(name="text")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String text(){
        return text_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String text_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qkeyevent.html#type">Qt3DInput::QKeyEvent::<wbr>type()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.QEvent.@NonNull Type type(){
        return io.qt.core.QEvent.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QKeyEvent(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}
     *  with <code>count = 1</code>.</p>
     */
    public QKeyEvent(io.qt.core.QEvent.@NonNull Type type, int key, io.qt.core.Qt.@NonNull KeyboardModifiers modifiers, java.lang.@NonNull String text, boolean autorep) {
        this(type, key, modifiers, text, autorep, (short)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}</p>
     * <p>with: </p><ul>
     * <li><code>autorep = false</code></li>
     * <li><code>count = 1</code></li>
     * </ul>
     */
    public QKeyEvent(io.qt.core.QEvent.@NonNull Type type, int key, io.qt.core.Qt.@NonNull KeyboardModifiers modifiers, java.lang.@NonNull String text) {
        this(type, key, modifiers, text, (boolean)false, (short)1);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QKeyEvent(io.qt.core.QEvent.Type, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, short)}</p>
     * <p>with: </p><ul>
     * <li><code>text = (String)null</code></li>
     * <li><code>autorep = false</code></li>
     * <li><code>count = 1</code></li>
     * </ul>
     */
    public QKeyEvent(io.qt.core.QEvent.@NonNull Type type, int key, io.qt.core.Qt.@NonNull KeyboardModifiers modifiers) {
        this(type, key, modifiers, (String)null, (boolean)false, (short)1);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #count()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCount() {
        return count();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAccepted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAccepted() {
        return isAccepted();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #key()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getKey() {
        return key();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #modifiers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getModifiers() {
        return modifiers();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #nativeScanCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getNativeScanCode() {
        return nativeScanCode();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #text()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getText() {
        return text();
    }
}
