package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Stores settings for the specified list of Axis</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html">Qt3DInput::QAxisSetting</a></code></p>
 */
public class QAxisSetting extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxisSetting.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#axesChanged">Qt3DInput::QAxisSetting::<wbr>axesChanged(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyNotify(name="axes")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@QtPrimitiveType@NonNull Integer>> axesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#deadZoneRadiusChanged">Qt3DInput::QAxisSetting::<wbr>deadZoneRadiusChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="deadZoneRadius")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> deadZoneRadiusChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#smoothChanged">Qt3DInput::QAxisSetting::<wbr>smoothChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="smooth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> smoothChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#QAxisSetting">Qt3DInput::QAxisSetting::<wbr>QAxisSetting(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAxisSetting(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxisSetting instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>QAxisSetting::axes Returns the current list of Axis these settings apply to</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#axes">Qt3DInput::QAxisSetting::<wbr>axes()const</a></code></p>
     */
    @QtPropertyReader(name="axes")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> axes(){
        return axes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<java.lang.@QtPrimitiveType Integer> axes_native_constfct(long __this__nativeId);
    
    /**
     * <p>QAxisSetting::deadZoneRadius Returns the set dead zone radius</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#deadZoneRadius">Qt3DInput::QAxisSetting::<wbr>deadZoneRadius()const</a></code></p>
     */
    @QtPropertyReader(name="deadZoneRadius")
    @QtUninvokable
    public final float deadZoneRadius(){
        return deadZoneRadius_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float deadZoneRadius_native_constfct(long __this__nativeId);
    
    /**
     * <p>QAxisSetting::isSmoothEnabled Returns if smoothing is enabled</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#isSmoothEnabled">Qt3DInput::QAxisSetting::<wbr>isSmoothEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="smooth")
    @QtUninvokable
    public final boolean isSmoothEnabled(){
        return isSmoothEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isSmoothEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#setAxes">Qt3DInput::QAxisSetting::<wbr>setAxes(QList&lt;int&gt;)</a></code></p>
     */
    @QtPropertyWriter(name="axes")
    public final void setAxes(java.util.@NonNull Collection<java.lang.@QtPrimitiveType@NonNull Integer> axes){
        setAxes_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), axes);
    }
    
    private native void setAxes_native_cref_QList(long __this__nativeId, java.util.Collection<java.lang.@QtPrimitiveType Integer> axes);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#setDeadZoneRadius">Qt3DInput::QAxisSetting::<wbr>setDeadZoneRadius(float)</a></code></p>
     */
    @QtPropertyWriter(name="deadZoneRadius")
    public final void setDeadZoneRadius(float deadZoneRadius){
        setDeadZoneRadius_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), deadZoneRadius);
    }
    
    private native void setDeadZoneRadius_native_float(long __this__nativeId, float deadZoneRadius);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxissetting.html#setSmoothEnabled">Qt3DInput::QAxisSetting::<wbr>setSmoothEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="smooth")
    public final void setSmoothEnabled(boolean enabled){
        setSmoothEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setSmoothEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxisSetting(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAxisSetting(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxisSetting instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxisSetting(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxisSetting() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axes()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<java.lang.@QtPrimitiveType@NonNull Integer> getAxes() {
        return axes();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #deadZoneRadius()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDeadZoneRadius() {
        return deadZoneRadius();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isSmoothEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSmooth() {
        return isSmoothEnabled();
    }
}
