package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>Stores QAbstractAxisInputs used to trigger an input event</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html">Qt3DInput::QAxis</a></code></p>
 */
public class QAxis extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAxis.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#value-prop">Qt3DInput::QAxis::<wbr>valueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="value")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> valueChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#QAxis">Qt3DInput::QAxis::<wbr>QAxis(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAxis(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAxis instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#addInput">Qt3DInput::QAxis::<wbr>addInput(Qt3DInput::QAbstractAxisInput*)</a></code></p>
     */
    @QtUninvokable
    public final void addInput(io.qt.qt3d.input.@Nullable QAbstractAxisInput input){
        addInput_native_Qt3DInput_QAbstractAxisInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void addInput_native_Qt3DInput_QAbstractAxisInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#inputs">Qt3DInput::QAxis::<wbr>inputs()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.input.@Nullable QAbstractAxisInput> inputs(){
        return inputs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.input.QAbstractAxisInput> inputs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#removeInput">Qt3DInput::QAxis::<wbr>removeInput(Qt3DInput::QAbstractAxisInput*)</a></code></p>
     */
    @QtUninvokable
    public final void removeInput(io.qt.qt3d.input.@Nullable QAbstractAxisInput input){
        removeInput_native_Qt3DInput_QAbstractAxisInput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(input));
    }
    
    @QtUninvokable
    private native void removeInput_native_Qt3DInput_QAbstractAxisInput_ptr(long __this__nativeId, long input);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qaxis.html#value-prop">Qt3DInput::QAxis::<wbr>value()const</a></code></p>
     */
    @QtPropertyReader(name="value")
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAxis(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAxis(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAxis instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAxis(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAxis() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #value()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getValue() {
        return value();
    }
}
