package io.qt.qt3d.input;

import io.qt.*;


/**
 * <p>An axis input controlled by an analog input The axis value is controlled like a traditional analog input such as a joystick</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3dinput-qanalogaxisinput.html">Qt3DInput::QAnalogAxisInput</a></code></p>
 */
public class QAnalogAxisInput extends io.qt.qt3d.input.QAbstractAxisInput
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAnalogAxisInput.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qanalogaxisinput.html#axis-prop">Qt3DInput::QAnalogAxisInput::<wbr>axisChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="axis")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> axisChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qanalogaxisinput.html#QAnalogAxisInput">Qt3DInput::QAnalogAxisInput::<wbr>QAnalogAxisInput(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAnalogAxisInput(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAnalogAxisInput instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qanalogaxisinput.html#axis-prop">Qt3DInput::QAnalogAxisInput::<wbr>axis()const</a></code></p>
     */
    @QtPropertyReader(name="axis")
    @QtUninvokable
    public final int axis(){
        return axis_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int axis_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3dinput-qanalogaxisinput.html#axis-prop">Qt3DInput::QAnalogAxisInput::<wbr>setAxis(int)</a></code></p>
     */
    @QtPropertyWriter(name="axis")
    public final void setAxis(int axis){
        setAxis_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), axis);
    }
    
    private native void setAxis_native_int(long __this__nativeId, int axis);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAnalogAxisInput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QAnalogAxisInput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAnalogAxisInput instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAnalogAxisInput(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAnalogAxisInput() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #axis()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getAxis() {
        return axis();
    }
}
